/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import java.util.Iterator;

public class SelectionIntensity
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public SelectionIntensity(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Selection Intensity";
    }

    public String getDescription() {
        return "Computes the quota of individuals born in the current generation.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        int count = 0;
        Iterator iter = individualList.iterator();
        while (iter.hasNext()) {
            Individual individual = (Individual)iter.next();
            if (individual.getDateOfBirth() != this.getSchedule().getCurrentGeneration()) continue;
            ++count;
        }
        this.updateViews(new Double(count));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

