/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.transformer;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractSingleObjectiveFitnessFunction;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.searchspace.HasMetric;
import java.util.Iterator;

public class FitnessSharing
extends AbstractSingleObjectiveFitnessFunction
implements FitnessTransformer,
Configurable {
    private FitnessFunction delegate;
    private double alpha = 1.0;
    private double sigma_share = 5.0;
    private boolean active = true;

    public FitnessSharing(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (this.getFitnessFunction() == null ? !(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction) : !(this.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
        if (!(schedule.getPhenotypeSearchSpace() instanceof HasMetric)) {
            throw new UnsupportedEnvironmentException("Search space has no metric.");
        }
        try {
            ((SingleObjectiveFitnessFunction)schedule.getRealFitnessFunction()).getLowerBound();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("no lower bound");
        }
    }

    public void setFitnessFunction(FitnessFunction fitness) {
        this.delegate = fitness;
    }

    public FitnessFunction getFitnessFunction() {
        return this.delegate;
    }

    public Double getPropertyAlpha() {
        return new Double(this.alpha);
    }

    public void setPropertyAlpha(Double a) {
        if (a > 0.0) {
            this.alpha = a;
        }
    }

    public String getLongDescriptionForAlpha() {
        return "Regulates the shape of the sharing function.";
    }

    public Double getPropertySigma_share() {
        return new Double(this.sigma_share);
    }

    public void setPropertySigma_share(Double ss) {
        if (ss > 0.0) {
            this.sigma_share = ss;
        }
    }

    public String getLongDescriptionForSigma_share() {
        return "Two individuals do not affect each other, if the distance between them is greater or equal to sigma_share.";
    }

    public Boolean getPropertyActive() {
        return new Boolean(this.active);
    }

    public void setPropertyActive(Boolean a) {
        this.active = a;
    }

    public String getLongDescriptionForActive() {
        return "Enables or disables fitness sharing. May be used by parameter controllers to activate or deactivate fitness sharing.";
    }

    private double sh(double distance) {
        if (distance < this.sigma_share) {
            return 1.0 - Math.pow(distance / this.sigma_share, this.alpha);
        }
        return 0.0;
    }

    public double evaluate(Individual ind, IndividualList p) {
        if (!this.active || p == null) {
            return ((SingleObjectiveFitnessFunction)this.delegate).evaluate(ind, p);
        }
        double add = 0.0;
        try {
            double low = ((SingleObjectiveFitnessFunction)this.delegate).getLowerBound();
            if (low < 0.0) {
                add = 0.0 - low;
            }
        }
        catch (UnsupportedOperationException low) {
            // empty catch block
        }
        double niche_count = 0.0;
        HasMetric metric = (HasMetric)((Object)this.getSchedule().getPhenotypeSearchSpace());
        Genotype gt = ind.getPhenotype();
        Iterator it = p.iterator();
        while (it.hasNext()) {
            Individual i = (Individual)it.next();
            niche_count += this.sh(metric.getDistance(gt, i.getPhenotype()));
        }
        return (((SingleObjectiveFitnessFunction)this.delegate).evaluate(ind, p) + add) / niche_count - add;
    }

    public String getDescription() {
        return "Fitness sharing derates the individual fitness by dividing it by the individual niche count. The niche count is the sum of shared function values, calulated by distances between the individual and all population elements.";
    }

    public String getName() {
        return "Fitness Sharing";
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return ((SingleObjectiveFitnessFunction)this.delegate).getUpperBound();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

