/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.util;

import freak.module.fitness.pointset.math.EqSolvers;
import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;
import freak.module.fitness.pointset.util.HyperPlane;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.searchspace.PointSet;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidualHyperPlane
extends HyperPlane
implements Serializable {
    public ResidualHyperPlane() {
    }

    public ResidualHyperPlane(PointSet.Point[] supportPoints) {
        super(supportPoints);
    }

    public void updateResiduals(Collection<ResidualContainer> col, PointSet.Point[] pAllPoints) {
        int i = 0;
        for (ResidualContainer aktRes : col) {
            double resValue = 0.0;
            try {
                resValue = pAllPoints[i].getK(0) - this.parameter.get(0);
                int j = 1;
                while (j < this.dimension) {
                    resValue -= this.parameter.get(j) * pAllPoints[i].getK(j);
                    ++j;
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            aktRes.pointIndexInPointSet = i++;
            aktRes.signedResidual = resValue;
            aktRes.squaredResidual = resValue * resValue;
        }
    }

    private void updateResidual(PointSet.Point[] pAllPoints, ResidualContainer residual) {
        double resValue = 0.0;
        try {
            resValue = pAllPoints[residual.pointIndexInPointSet].getK(0) - this.parameter.get(0);
            int j = 1;
            while (j < this.dimension) {
                resValue -= this.parameter.get(j) * pAllPoints[residual.pointIndexInPointSet].getK(j);
                ++j;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        residual.signedResidual = resValue;
        residual.squaredResidual = resValue * resValue;
    }

    public void updateResiduals(ResidualContainer[] col, PointSet.Point[] pAllPoints) {
        int i = 0;
        while (i < col.length) {
            double resValue = 0.0;
            if (col[i] != null) {
                col[i].pointIndexInPointSet = i;
            } else {
                col[i] = new ResidualContainer(i, 0.0, 0.0);
            }
            this.updateResidual(pAllPoints, col[i]);
            ++i;
        }
    }

    public void computeParamLS(PointSet.Point[] pAllPoints, ResidualContainer[] residuals, int quantile) {
        Matrix m = new Matrix(this.dimension);
        NormalView vm = new NormalView(m);
        int i = 0;
        while (i < this.dimension) {
            int j = 0;
            while (j < this.dimension) {
                double w = 0.0;
                int k = 0;
                while (k < quantile) {
                    double a = i == 0 ? 1.0 : pAllPoints[residuals[k].pointIndexInPointSet].getK(i);
                    double b = j == 0 ? 1.0 : pAllPoints[residuals[k].pointIndexInPointSet].getK(j);
                    w += a * b;
                    ++k;
                }
                try {
                    vm.set(i, j, w);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
                ++j;
            }
            ++i;
        }
        Vector b = new Vector(this.dimension);
        VectorView vb = new VectorView(b);
        int i2 = 0;
        while (i2 < this.dimension) {
            double w = 0.0;
            int k = 0;
            while (k < quantile) {
                double a = 0.0;
                a = i2 == 0 ? 1.0 : pAllPoints[residuals[k].pointIndexInPointSet].getK(i2);
                w += a * pAllPoints[residuals[k].pointIndexInPointSet].getK(0);
                ++k;
            }
            try {
                vb.set(i2, w);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            ++i2;
        }
        try {
            EqSolvers solver = new EqSolvers(m, b);
            this.parameter = new VectorView(solver.solve());
            int i3 = 0;
            while (i3 < quantile) {
                this.updateResidual(pAllPoints, residuals[i3]);
                ++i3;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static void main(String[] args) {
        PointSet.Point[] testPoints = new PointSet.Point[]{new PointSet.Point(2), new PointSet.Point(2)};
        testPoints[0].setK(0, 1.0);
        testPoints[0].setK(1, 1.0);
        testPoints[1].setK(0, 2.0);
        testPoints[1].setK(1, 2.0);
        ResidualHyperPlane testPlane = new ResidualHyperPlane(testPoints);
        System.out.println("Done");
        PointSet.Point testPoint = new PointSet.Point(2);
        testPoint.setK(0, 1.0);
        testPoint.setK(1, 1.0);
        double resValue = -1.0;
        try {
            resValue = testPoint.getK(0) - testPlane.parameter.get(0);
            int j = 1;
            while (j < testPlane.dimension) {
                resValue -= testPlane.parameter.get(j) * testPoint.getK(j);
                ++j;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        System.out.println(resValue);
    }
}

