/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.Schedule;
import freak.gui.scheduleeditor.BatchTableCellRenderer;
import freak.gui.scheduleeditor.BatchTableModel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BatchTable
extends JTable {
    private Schedule schedule;
    private BatchList batchList;
    private TableCellRenderer renderer;
    private AbstractTableModel model;

    public BatchTable(Schedule schedule) {
        this.schedule = schedule;
        this.batchList = schedule.getBatchList();
        this.model = new BatchTableModel(schedule);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.renderer = new BatchTableCellRenderer(schedule);
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            TableColumn col = this.getColumnModel().getColumn(i);
            if (i == 0 || i == 4) {
                col.setPreferredWidth(40);
            }
            ++i;
        }
    }

    public void updateRows(int from, int to) {
        this.model.fireTableRowsUpdated(from, to);
    }

    public void appendBatch(Batch batch, boolean applyConfigurationCode) {
        this.batchList.add(batch, applyConfigurationCode);
        this.model.fireTableRowsInserted(this.batchList.size() - 1, this.batchList.size() - 1);
    }

    public void deleteRow(int row) {
        this.batchList.removeBatch(row);
        this.model.fireTableRowsDeleted(row, row);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.renderer;
    }
}

