/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static GraphCellEditor cellEditor = new DefaultGraphCellEditor();
    protected JGraph graph = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected Map attributes = GraphConstants.createMap();
    protected Map allAttributes;

    public AbstractCellView(Object object, JGraph jGraph, CellMapper cellMapper) {
        this.cell = object;
        this.graph = jGraph;
        this.mapper = cellMapper;
        this.updateAllAttributes();
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    public Object getCell() {
        return this.cell;
    }

    public void refresh(boolean bl) {
        boolean bl2;
        Object object;
        this.update();
        if (this.mapper != null && this.getModel() != null) {
            Object object2 = this.getModel().getParent(this.cell);
            if (this.graph.getGraphLayoutCache().isVisible(object2)) {
                object = this.mapper.getMapping(object2, bl);
                if (object != this.parent) {
                    this.removeFromParent();
                }
                this.parent = object;
            } else if (this.parent != null) {
                this.removeFromParent();
                this.parent = null;
            }
        }
        boolean bl3 = bl2 = !this.graph.getGraphLayoutCache().isOrdered();
        if (bl2) {
            this.childViews.clear();
        }
        object = this.getModel();
        int n = 0;
        while (n < object.getChildCount(this.cell)) {
            CellView cellView;
            Object object3 = object.getChild(this.cell, n);
            if (this.graph.getGraphLayoutCache().isVisible(object3) && (cellView = this.mapper.getMapping(object3, bl)) != null && !object.isPort(object3) && (!this.childViews.contains(cellView) || bl2)) {
                this.childViews.add(cellView);
            }
            ++n;
        }
    }

    public void update() {
        this.updateAllAttributes();
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        this.allAttributes = this.getModel().getAttributes(this.cell);
        this.allAttributes = this.allAttributes != null ? GraphConstants.cloneMap(this.allAttributes) : GraphConstants.createMap();
        this.allAttributes.putAll(this.attributes);
    }

    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        Object object;
        Stack<CellView> stack = new Stack<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            stack.add(cellViewArray[n]);
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object = (CellView)stack.pop();
            CellView[] cellViewArray2 = object.getChildViews();
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                stack.add(cellViewArray2[n2]);
                ++n2;
            }
            arrayList.add(object);
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getAllAttributes() {
        return this.allAttributes;
    }

    public Map setAttributes(Map map) {
        Map map2 = GraphConstants.applyMap(map, this.attributes);
        this.update();
        return map2;
    }

    public abstract Rectangle getBounds();

    public static Rectangle getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle rectangle = null;
            int n = 0;
            while (n < cellViewArray.length) {
                Rectangle rectangle2;
                if (cellViewArray[n] != null && (rectangle2 = cellViewArray[n].getBounds()) != null) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(rectangle2);
                    } else {
                        SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
                    }
                }
                ++n;
            }
            return rectangle;
        }
        return null;
    }

    public void setBounds(Rectangle rectangle) {
        Dimension dimension;
        Point point;
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2 != null) {
            point = rectangle2.getLocation();
            dimension = rectangle2.getSize();
        } else {
            point = new Point(0, 0);
            dimension = new Dimension(0, 0);
        }
        Point point2 = rectangle.getLocation();
        Rectangle rectangle3 = new Rectangle(rectangle);
        if (GraphConstants.isMoveable(this.getAttributes()) && !point2.equals(point)) {
            this.translate(point2.x - point.x, point2.y - point.y);
        } else {
            rectangle3.setSize(rectangle.width - point2.x + point.x, rectangle.height - point2.y + point.y);
        }
        Dimension dimension2 = rectangle3.getSize();
        if (!dimension.equals(dimension2) && dimension.width > 0 && dimension.height > 0) {
            double d = (double)dimension2.width / (double)dimension.width;
            double d2 = (double)dimension2.height / (double)dimension.height;
            this.scale(d, d2, point2);
        }
    }

    protected void translate(int n, int n2) {
        if (this.isLeaf()) {
            GraphConstants.translate(this.getAttributes(), n, n2);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView)) continue;
                AbstractCellView abstractCellView = (AbstractCellView)e;
                abstractCellView.translate(n, n2);
            }
        }
    }

    protected void scale(double d, double d2, Point point) {
        if (this.isLeaf()) {
            GraphConstants.scale(this.getAttributes(), d, d2, point);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                AbstractCellView abstractCellView;
                Map map;
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView) || !GraphConstants.isSizeable(map = (abstractCellView = (AbstractCellView)e).getAttributes()) && !GraphConstants.isAutoSize(map)) continue;
                abstractCellView.scale(d, d2, point);
            }
        }
    }

    public boolean intersects(Graphics graphics, Rectangle rectangle) {
        if (this.isLeaf()) {
            Rectangle rectangle2 = this.getBounds();
            if (rectangle2 != null) {
                return rectangle2.intersects(rectangle);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(graphics, rectangle)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph jGraph, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(jGraph, this, bl, bl2, bl3);
        }
        return null;
    }

    protected abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }
}

