/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.HasMetric;
import freak.module.searchspace.PermutationGenotype;

public class Cycle
extends AbstractSearchSpace
implements Configurable,
HasMetric,
HasDimension {
    private int dimension = 100;

    public Cycle(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Cycle";
    }

    public String getDescription() {
        return "Represents all permutations in the symmetric group S_{dimension} which form a cycle (e.g. a TSP-tour).\nThat are all permutations of the elements {1,...,dimension} which form a cycle.";
    }

    private double factorial(int n) {
        if (n == 1) {
            return 1.0;
        }
        return (double)n * this.factorial(n - 1);
    }

    public double getSize() {
        if (this.dimension > 171) {
            return Double.POSITIVE_INFINITY;
        }
        return this.factorial(this.dimension - 1);
    }

    public Genotype getRandomGenotype() {
        int[] gt = new int[this.dimension];
        RandomElement re = this.schedule.getRandomElement();
        int i = 0;
        while (i < this.dimension) {
            gt[i] = i + 1;
            ++i;
        }
        i = 0;
        while (i < this.dimension - 1) {
            int j = re.choose(i, this.dimension - 1);
            int tmp = gt[i];
            gt[i] = gt[j];
            gt[j] = tmp;
            ++i;
        }
        return new PermutationGenotype(gt);
    }

    public double getDistance(Genotype gt1, Genotype gt2) {
        int[] cgt1 = ((PermutationGenotype)gt1).getIntArray();
        int[] cgt2 = ((PermutationGenotype)gt2).getIntArray();
        int[][] c = new int[this.dimension][2];
        int distance = this.dimension;
        int i = 0;
        while (i < this.dimension) {
            c[cgt1[i] - 1][0] = cgt1[(i + 1) % this.dimension];
            c[cgt1[(i + 1) % this.dimension] - 1][1] = cgt1[i];
            ++i;
        }
        i = 0;
        while (i < this.dimension) {
            if (c[cgt2[i] - 1][0] == cgt2[(i + 1) % this.dimension] || c[cgt2[i] - 1][0] == cgt2[(i - 1 + this.dimension) % this.dimension]) {
                --distance;
            }
            ++i;
        }
        return distance;
    }

    public String getLongDescriptionForDimension() {
        return "Elements in this search space are permutations in the symmetric group S_{dimension} which form a cycle.";
    }

    public void setPropertyDimension(Integer dim) {
        if (dim > 1) {
            this.dimension = dim;
        }
    }

    public Integer getPropertyDimension() {
        return new Integer(this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }
}

