/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class HSP
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k = 1;

    public HSP(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int cardinality = bs.cardinality();
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int maxOnes = (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k;
        if (cardinality % this.k == 0 && cardinality <= maxOnes) {
            BitSet tbs = new BitSet(n);
            tbs.set(0, cardinality);
            if (bs.equals(tbs)) {
                return n * (cardinality + 1);
            }
        }
        int zd = (int)Math.ceil((double)(2 * n) / 3.0);
        BitSet tbs = new BitSet(n);
        tbs.set(0, zd);
        tbs.and(bs);
        if (tbs.cardinality() == 0) {
            return n + cardinality;
        }
        return n - cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        return (double)n * (Math.ceil((double)n / (double)(3 * this.k)) * (double)this.k + 1.0);
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension());
        bs.set(0, (int)Math.ceil((double)n / (double)(3 * this.k)) * this.k);
        return new BitStringGenotype(bs, ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension());
    }

    public void setPropertyK(Integer k) {
        if (k > 0) {
            this.k = k;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForK() {
        return "k";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        return "Hamming Short Path k has a short path similar to the function Short Path k which is easy to find. However, since once being at the beginning of the path it is much more likely to go away from the path then to follow it, we expect that the success probability pHSP_k,t(n) is rather small for each t = n^O(1).";
    }

    public String getName() {
        return "Hamming Short Path k";
    }
}

