/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view.swingsupport;

import freak.core.view.swingsupport.FreakSwingModel;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public class UpdateManager {
    private static Set dirtyModels = new HashSet();

    static {
        new PeriodicUpdate().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markDirty(FreakSwingModel dirtyModel) {
        Set set = dirtyModels;
        synchronized (set) {
            dirtyModels.add(dirtyModel);
            dirtyModels.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAll() {
        Object[] snapshot;
        Set set = dirtyModels;
        synchronized (set) {
            snapshot = dirtyModels.toArray();
            dirtyModels.clear();
        }
        int i = 0;
        while (i < snapshot.length) {
            FreakSwingModel model;
            FreakSwingModel freakSwingModel = model = (FreakSwingModel)snapshot[i];
            synchronized (freakSwingModel) {
                model.flush();
            }
            ++i;
        }
    }

    private static class PeriodicUpdate
    extends Thread {
        private static final long delay = 100L;
        private static long lastUpdate = 0L;
        private static boolean failed;

        public PeriodicUpdate() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Set set = dirtyModels;
                    synchronized (set) {
                        while (dirtyModels.isEmpty()) {
                            dirtyModels.wait();
                        }
                    }
                    long now = System.currentTimeMillis();
                    long remaining = 100L - now + lastUpdate;
                    if (remaining > 0L) {
                        Thread.sleep(remaining);
                    }
                    if (!failed) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    PeriodicUpdate.this.update();
                                }
                            });
                        }
                        catch (Error err) {
                            failed = true;
                        }
                    }
                    if (!failed) continue;
                    this.update();
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }

        private void update() {
            UpdateManager.flushAll();
            lastUpdate = System.currentTimeMillis();
        }
    }
}

