/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.core.control.EventController;
import freak.core.control.EventInfo;
import freak.core.control.Schedule;
import freak.core.event.EventSource;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.FreakEdge;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.FreakPort;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.graph.OperatorGraphCell;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import freak.core.modulesupport.ClassPersistenceHandler;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.PersistenceManager;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.modulesupport.XMLizeException;
import freak.core.parametercontroller.ParameterController;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class OperatorGraphFile
implements Serializable {
    private ArrayList nodeList = new ArrayList();
    private ArrayList edgeList = new ArrayList();
    private ArrayList parameterControllerList = new ArrayList();

    private OperatorGraphFile() {
    }

    public OperatorGraphFile(FreakGraphModel graphModel) {
        OperatorGraphCell cell;
        Object o;
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        int i = 0;
        while (i < graphModel.getRootCount()) {
            o = graphModel.getRootAt(i);
            if (o instanceof OperatorGraphCell) {
                cell = (OperatorGraphCell)o;
                this.nodeList.add(new Node(cell));
                map.put(graphModel.getRootAt(i), new Integer(this.nodeList.size() - 1));
            }
            ++i;
        }
        i = 0;
        while (i < graphModel.getRootCount()) {
            o = graphModel.getRootAt(i);
            if (o instanceof FreakEdge) {
                FreakEdge edge = (FreakEdge)o;
                this.edgeList.add(new Edge(edge, map));
            }
            ++i;
        }
        i = 0;
        while (i < graphModel.getRootCount()) {
            o = graphModel.getRootAt(i);
            if (o instanceof OperatorGraphCell) {
                cell = (OperatorGraphCell)o;
                int index = (Integer)map.get(cell);
                Node node = (Node)this.nodeList.get(index);
                node.events = this.createEventListFor(cell.getOperator(), graphModel, map);
            }
            ++i;
        }
        List parameterController = graphModel.getOperatorGraph().getParameterControllers();
        int i2 = 0;
        while (i2 < parameterController.size()) {
            PController pc = new PController((ParameterController)parameterController.get(i2), map, graphModel.getOperatorMapper());
            pc.events = this.createEventListFor((ParameterController)parameterController.get(i2), graphModel, map);
            this.parameterControllerList.add(pc);
            ++i2;
        }
    }

    public FreakGraphModel generateGraph(Schedule schedule) throws UnsupportedEnvironmentException, InvocationTargetException {
        OperatorGraph operatorGraph = new OperatorGraph(null);
        operatorGraph.setSchedule(schedule);
        ArrayList<Operator> operatorList = new ArrayList<Operator>();
        ModuleCollector manager = new ModuleCollector(schedule);
        int i = 0;
        while (i < this.nodeList.size()) {
            Node n = (Node)this.nodeList.get(i);
            if (n.type.compareTo("freak.core.graph.Start") != 0 && n.type.compareTo("freak.core.graph.Finish") != 0) {
                Operator operator = (Operator)manager.newModuleByString(n.type, new Object[]{operatorGraph}, schedule.getGenotypeSearchSpace());
                if (n.config != null) {
                    operator.setConfiguration(n.config);
                }
                operatorGraph.addOperator(operator);
                operatorList.add(i, operator);
            } else if (n.type.compareTo("freak.core.graph.Finish") != 0) {
                operatorList.add(i, operatorGraph.getStart());
            } else {
                operatorList.add(i, operatorGraph.getFinish());
            }
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            Edge e = (Edge)this.edgeList.get(i);
            OutPort source = ((Operator)operatorList.get(e.source)).getOutPort(e.sourcePort);
            InPort target = ((Operator)operatorList.get(e.target)).getInPort(e.targetPort);
            ((Port)source).addPartner(target);
            ++i;
        }
        List parameterController = operatorGraph.getParameterControllers();
        int j = 0;
        while (j < this.parameterControllerList.size()) {
            PController pcWrapper = (PController)this.parameterControllerList.get(j);
            ParameterController pc = (ParameterController)manager.newModuleByString(pcWrapper.type, new Object[]{operatorGraph}, schedule.getGenotypeSearchSpace());
            Set keySet = pcWrapper.parameters.keySet();
            for (String key : keySet) {
                PWrapper value = (PWrapper)pcWrapper.parameters.get(key);
                pc.setPropertyForParameter(key, (Operator)operatorList.get(value.operator), value.propName);
            }
            parameterController.add(pc);
            pc.createEvents();
            this.restoreEvents(pc, pcWrapper.events, operatorList, schedule);
            ++j;
        }
        FreakGraphModel result = new FreakGraphModel(operatorGraph);
        int i2 = 0;
        while (i2 < result.getRootCount()) {
            Object o = result.getRootAt(i2);
            if (o instanceof OperatorGraphCell) {
                OperatorGraphCell cell = (OperatorGraphCell)o;
                Map attributes = ((Node)this.nodeList.get((int)operatorList.indexOf((Object)cell.getOperator()))).attributes;
                attributes.put("value", cell.getOperator());
                cell.setAttributes(attributes);
                cell.adjustPortPositions();
            } else {
                boolean cfr_ignored_0 = o instanceof FreakEdge;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < operatorList.size()) {
            Operator operator = (Operator)operatorList.get(i2);
            Node node = (Node)this.nodeList.get(i2);
            operator.createEvents();
            this.restoreEvents(operator, node.events, operatorList, schedule);
            ++i2;
        }
        operatorGraph.createEvents();
        return result;
    }

    private int getEdgeIndexForPort(Port port, FreakGraphModel model, Map map) {
        Operator operator = port.getOperator();
        int source = (Integer)map.get(model.getOperatorMapper().get(operator));
        int sourcePort = operator.getIndexOfPort(port) - operator.getNumberOfInPorts();
        int i = 0;
        while (i < this.edgeList.size()) {
            Edge edge = (Edge)this.edgeList.get(i);
            if (edge.source == source && edge.sourcePort == sourcePort) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List createEventListFor(Module m, FreakGraphModel model, Map map) {
        ArrayList<Event> l = new ArrayList<Event>();
        EventController ec = model.getOperatorGraph().getSchedule().getEventController();
        List evts = ec.getCustomizableEventsFor(m);
        if (!evts.isEmpty()) {
            for (EventInfo evt : evts) {
                Event e = new Event();
                l.add(e);
                e.className = evt.getEventType().getName();
                e.name = evt.getEventName();
                EventSource source = evt.getEventSource();
                if (source != null) {
                    if (source instanceof SearchSpace) {
                        e.sourceType = 1;
                        continue;
                    }
                    if (source instanceof FitnessFunction) {
                        e.sourceType = 2;
                        continue;
                    }
                    if (source instanceof OperatorGraph) {
                        e.sourceType = 3;
                        continue;
                    }
                    if (source instanceof StoppingCriterion) {
                        e.sourceType = 4;
                        continue;
                    }
                    if (source instanceof PopulationManager) {
                        e.sourceType = 5;
                        continue;
                    }
                    if (source instanceof Schedule) {
                        e.sourceType = 6;
                        continue;
                    }
                    if (source instanceof Port) {
                        e.sourceType = 7;
                        Port port = (Port)((Object)source);
                        e.edgeIndex = this.getEdgeIndexForPort(port, model, map);
                        continue;
                    }
                    e.sourceType = 0;
                    continue;
                }
                e.sourceType = -1;
            }
        }
        return l;
    }

    private void restoreEvents(Module module, List events, List operatorList, Schedule schedule) {
        EventController ec = schedule.getEventController();
        int i = 0;
        while (i < events.size()) {
            Event event = (Event)events.get(i);
            EventInfo evt = ec.getCustomizableEventFor(module, event.name);
            Serializable eventSource = null;
            switch (event.sourceType) {
                case -1: {
                    eventSource = null;
                    break;
                }
                case 0: {
                    eventSource = null;
                    break;
                }
                case 1: {
                    eventSource = schedule.getGenotypeSearchSpace();
                    break;
                }
                case 2: {
                    eventSource = schedule.getRealFitnessFunction();
                    break;
                }
                case 3: {
                    eventSource = schedule.getOperatorGraph();
                    break;
                }
                case 5: {
                    eventSource = schedule.getPopulationManager();
                    break;
                }
                case 6: {
                    eventSource = schedule;
                    break;
                }
                case 7: {
                    Edge edge = (Edge)this.edgeList.get(event.edgeIndex);
                    Operator operator = (Operator)operatorList.get(edge.source);
                    eventSource = operator.getOutPort(edge.sourcePort);
                    break;
                }
                default: {
                    eventSource = null;
                }
            }
            evt.setEventSource((EventSource)((Object)eventSource));
            ++i;
        }
    }

    public void write(OutputStream s) throws IOException, XMLizeException {
        XMLOutputter outputter = new XMLOutputter("  ", true);
        outputter.output(PersistenceManager.XMLize(this), s);
    }

    public static OperatorGraphFile read(InputStream s) throws XMLizeException, IOException {
        SAXBuilder builder = new SAXBuilder();
        try {
            return (OperatorGraphFile)PersistenceManager.DeXMLize(builder.build(s));
        }
        catch (JDOMException e) {
            throw new XMLizeException(e);
        }
    }

    /* synthetic */ OperatorGraphFile(OperatorGraphFile operatorGraphFile) {
        this();
    }

    public static class Event
    implements Serializable {
        static final int SOURCE_NULL = -1;
        static final int SOURCE_UNKNOWN = 0;
        static final int SOURCE_SEARCHSPACE = 1;
        static final int SOURCE_FITNESSFUNCTION = 2;
        static final int SOURCE_OPERATORGRAPH = 3;
        static final int SOURCE_STOPPINGCRITERION = 4;
        static final int SOURCE_POPULATIONMANAGER = 5;
        static final int SOURCE_SCHEDULE = 6;
        static final int SOURCE_PORT = 7;
        int sourceType;
        String name;
        String className;
        int edgeIndex;

        public static class EventPersistenceHandler
        implements ClassPersistenceHandler {
            private PersistenceManager pm = null;

            public EventPersistenceHandler(PersistenceManager pm) {
                this.pm = pm;
            }

            public Element toXML(Object o) {
                Event event = (Event)o;
                Element result = new Element("Event");
                result.setAttribute("sourceType", String.valueOf(event.sourceType));
                result.setAttribute("name", event.name);
                result.setAttribute("className", event.className);
                result.setAttribute("edgeIndex", String.valueOf(event.edgeIndex));
                return result;
            }

            public Object fromXML(Element e) throws DataConversionException {
                Event event = new Event();
                event.sourceType = e.getAttribute("sourceType").getIntValue();
                event.name = e.getAttribute("name").getValue();
                event.className = e.getAttribute("className").getValue();
                event.edgeIndex = e.getAttribute("edgeIndex").getIntValue();
                return event;
            }

            public Class handles() {
                return Event.class;
            }
        }
    }

    public static class Node
    implements Serializable {
        String type;
        Map attributes;
        Configuration config = null;
        List events = null;

        private Node() {
        }

        public Node(OperatorGraphCell cell) {
            this.attributes = new Hashtable(cell.getAttributes());
            this.attributes.remove("value");
            this.type = cell.getOperator().getClass().getName();
            if (cell.getOperator() instanceof Configurable) {
                this.config = cell.getOperator().getConfiguration();
            }
        }

        public static class NodePersistenceHandler
        implements ClassPersistenceHandler {
            private PersistenceManager pm = null;

            public NodePersistenceHandler(PersistenceManager pm) {
                this.pm = pm;
            }

            public Element toXML(Object o) throws XMLizeException {
                Node node = (Node)o;
                Element result = new Element("Node");
                result.addContent(this.pm.toXML(node.attributes, Map.class));
                result.addContent(this.pm.toXML(node.config));
                result.addContent(this.pm.toXML(node.events, List.class));
                result.addContent(this.pm.toXML(node.type));
                return result;
            }

            public Object fromXML(Element e) throws XMLizeException {
                Node node = new Node();
                this.pm.registerObject(node);
                node.attributes = (Map)this.pm.fromXML((Element)e.getChildren().get(0));
                node.config = (Configuration)this.pm.fromXML((Element)e.getChildren().get(1));
                node.events = (List)this.pm.fromXML((Element)e.getChildren().get(2));
                node.type = (String)this.pm.fromXML((Element)e.getChildren().get(3));
                return node;
            }

            public Class handles() {
                return Node.class;
            }
        }
    }

    public static class Edge
    implements Serializable {
        int source = -1;
        int sourcePort = -1;
        int target = -1;
        int targetPort = -1;

        private Edge() {
        }

        public Edge(FreakEdge edge, Map map) {
            if (edge.getSourcePort() != null) {
                this.source = (Integer)map.get(edge.getSourcePort().getParent());
                this.sourcePort = ((FreakPort)edge.getSource()).getPort().getNumber();
            }
            if (edge.getTargetPort() != null) {
                this.target = (Integer)map.get(edge.getTargetPort().getParent());
                this.targetPort = ((FreakPort)edge.getTarget()).getPort().getNumber();
            }
        }

        public static class EdgePersistenceHandler
        implements ClassPersistenceHandler {
            private PersistenceManager pm = null;

            public EdgePersistenceHandler(PersistenceManager pm) {
                this.pm = pm;
            }

            public Element toXML(Object o) {
                Edge edge = (Edge)o;
                Element result = new Element("Edge");
                result.setAttribute("source", String.valueOf(edge.source));
                result.setAttribute("sourcePort", String.valueOf(edge.sourcePort));
                result.setAttribute("target", String.valueOf(edge.target));
                result.setAttribute("targetPort", String.valueOf(edge.targetPort));
                return result;
            }

            public Object fromXML(Element e) throws DataConversionException {
                Edge edge = new Edge();
                this.pm.registerObject(edge);
                edge.source = e.getAttribute("source").getIntValue();
                edge.sourcePort = e.getAttribute("sourcePort").getIntValue();
                edge.target = e.getAttribute("target").getIntValue();
                edge.targetPort = e.getAttribute("targetPort").getIntValue();
                return edge;
            }

            public Class handles() {
                return Edge.class;
            }
        }
    }

    public static class PWrapper
    implements Serializable {
        public String type;
        public int operator;
        public String propName;

        public static class PWrapperPersistenceHandler
        implements ClassPersistenceHandler {
            private PersistenceManager pm = null;

            public PWrapperPersistenceHandler(PersistenceManager pm) {
                this.pm = pm;
            }

            public Element toXML(Object o) {
                PWrapper pw = (PWrapper)o;
                Element result = new Element("Parameter");
                result.setAttribute("type", pw.type);
                result.setAttribute("operator", String.valueOf(pw.operator));
                result.setAttribute("name", pw.propName);
                return result;
            }

            public Object fromXML(Element e) throws DataConversionException {
                PWrapper pw = new PWrapper();
                pw.type = e.getAttribute("type").getValue();
                pw.operator = e.getAttribute("operator").getIntValue();
                pw.propName = e.getAttribute("name").getValue();
                return pw;
            }

            public Class handles() {
                return PWrapper.class;
            }
        }
    }

    public static class PController
    implements Serializable {
        Configuration config = null;
        HashMap parameters = new HashMap();
        String type;
        List events;

        private PController() {
        }

        public PController(ParameterController parameterController, Map map, Map operatorMapper) {
            this.type = parameterController.getClass().getName();
            if (parameterController instanceof Configurable) {
                this.config = ((Configurable)((Object)parameterController)).getConfiguration();
            }
            String[] params = parameterController.getListOfParameters();
            int i = 0;
            while (i < params.length) {
                PWrapper pw = new PWrapper();
                pw.type = parameterController.getParameterType(params[i]).getName();
                pw.operator = (Integer)map.get(operatorMapper.get(parameterController.getOperatorForParameter(params[i])));
                pw.propName = parameterController.getPropNameForParameter(params[i]);
                this.parameters.put(params[i], pw);
                ++i;
            }
        }

        public static class PControllerPersistenceHandler
        implements ClassPersistenceHandler {
            private PersistenceManager pm = null;

            public PControllerPersistenceHandler(PersistenceManager pm) {
                this.pm = pm;
            }

            public Element toXML(Object o) throws XMLizeException {
                PController pc = (PController)o;
                Element result = new Element("ParameterController");
                result.setAttribute("type", pc.type);
                result.addContent(this.pm.toXML(pc.config));
                result.addContent(this.pm.toXML(pc.parameters));
                result.addContent(this.pm.toXML(pc.events));
                return result;
            }

            public Object fromXML(Element e) throws DataConversionException, XMLizeException {
                PController pc = new PController();
                this.pm.registerObject(pc);
                pc.type = e.getAttributeValue("type");
                pc.config = (Configuration)this.pm.fromXML((Element)e.getChildren().get(0));
                pc.parameters = (HashMap)this.pm.fromXML((Element)e.getChildren().get(1));
                pc.events = (List)this.pm.fromXML((Element)e.getChildren().get(2));
                return pc;
            }

            public Class handles() {
                return PController.class;
            }
        }
    }

    public static class OperatorGraphFilePersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public OperatorGraphFilePersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            OperatorGraphFile ogf = (OperatorGraphFile)o;
            Element result = new Element("OperatorGraphFile");
            result.addContent(this.pm.toXML(ogf.edgeList, List.class));
            result.addContent(this.pm.toXML(ogf.nodeList, List.class));
            result.addContent(this.pm.toXML(ogf.parameterControllerList, List.class));
            return result;
        }

        public Object fromXML(Element e) throws XMLizeException {
            OperatorGraphFile ogf = new OperatorGraphFile(null);
            this.pm.registerObject(ogf);
            ogf.edgeList = (ArrayList)this.pm.fromXML((Element)e.getChildren().get(0));
            ogf.nodeList = (ArrayList)this.pm.fromXML((Element)e.getChildren().get(1));
            ogf.parameterControllerList = (ArrayList)this.pm.fromXML((Element)e.getChildren().get(2));
            return ogf;
        }

        public Class handles() {
            return OperatorGraphFile.class;
        }
    }
}

