/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import freak.core.modulesupport.Module;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ModuleList
extends JList {
    public ModuleList() {
        this.setCellRenderer(new ModuleListCellRenderer());
    }

    public void setModules(Module[] modules, Module currentModule) {
        int selected = this.getSelectedIndex();
        DefaultListModel<Module> listModel = new DefaultListModel<Module>();
        int i = 0;
        while (i < modules.length) {
            if (currentModule != null && this.sameClass(modules[i], currentModule)) {
                listModel.addElement(currentModule);
                selected = i;
            } else {
                listModel.addElement(modules[i]);
            }
            ++i;
        }
        if (selected == -1 && modules.length > 0) {
            selected = 0;
        }
        this.setModel(listModel);
        this.setSelectedIndex(selected);
    }

    boolean sameClass(Module m1, Module m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getClass().equals(m2.getClass());
    }

    private class ModuleListCellRenderer
    extends DefaultListCellRenderer {
        private String moduleName = "N/A";

        private ModuleListCellRenderer() {
        }

        public String getText() {
            return this.moduleName;
        }

        public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            this.moduleName = arg1 != null ? ((Module)arg1).getName() : "(none)";
            return super.getListCellRendererComponent((JList<?>)arg0, arg1, arg2, arg3, arg4);
        }
    }
}

