/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public abstract class JButtonFactory {
    private static JButtonFactoryDelegate instance = new DefaultJButtonFactory();

    public static JButton newButton() {
        return instance.newButton();
    }

    public static JButton newButton(Icon arg0) {
        return instance.newButton(arg0);
    }

    public static JButton newButton(String arg0) {
        return instance.newButton(arg0);
    }

    public static JButton newButton(Action arg0) {
        return instance.newButton(arg0);
    }

    public static JButton newButton(String arg0, Icon arg1) {
        return instance.newButton(arg0, arg1);
    }

    public static void activateBugFix() {
        instance = new MacOSJButtonFactory();
    }

    private static interface JButtonFactoryDelegate {
        public JButton newButton();

        public JButton newButton(Icon var1);

        public JButton newButton(String var1);

        public JButton newButton(Action var1);

        public JButton newButton(String var1, Icon var2);
    }

    private static class DefaultJButtonFactory
    implements JButtonFactoryDelegate {
        private DefaultJButtonFactory() {
        }

        public JButton newButton() {
            return new JButton();
        }

        public JButton newButton(Icon arg0) {
            return new JButton(arg0);
        }

        public JButton newButton(String arg0) {
            return new JButton(arg0);
        }

        public JButton newButton(Action arg0) {
            return new JButton(arg0);
        }

        public JButton newButton(String arg0, Icon arg1) {
            return new JButton(arg0, arg1);
        }
    }

    private static class MacOSJButtonFactory
    implements JButtonFactoryDelegate {
        private MacOSJButtonFactory() {
        }

        public JButton newButton() {
            return new MacOSJButton();
        }

        public JButton newButton(Icon arg0) {
            return new MacOSJButton(arg0);
        }

        public JButton newButton(String arg0) {
            return new MacOSJButton(arg0);
        }

        public JButton newButton(Action arg0) {
            return new MacOSJButton(arg0);
        }

        public JButton newButton(String arg0, Icon arg1) {
            return new MacOSJButton(arg0, arg1);
        }
    }

    private static class MacOSJButton
    extends JButton {
        private static int height = new JButton((String)"A").getPreferredSize().height;

        public MacOSJButton() {
        }

        public MacOSJButton(Icon arg0) {
            super(arg0);
        }

        public MacOSJButton(String arg0) {
            super(arg0);
        }

        public MacOSJButton(Action arg0) {
            super(arg0);
        }

        public MacOSJButton(String arg0, Icon arg1) {
            super(arg0, arg1);
        }

        public void setIcon(Icon arg0) {
            super.setIcon(arg0);
            int width = new JButton((String)this.getText()).getPreferredSize().width + arg0.getIconWidth() + this.getIconTextGap();
            this.setPreferredSize(new Dimension(width, height));
            this.setMinimumSize(new Dimension(width, height));
        }
    }
}

