/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class VonMises
extends AbstractContinousDistribution {
    protected double my_k;
    private double k_set = -1.0;
    private double tau;
    private double rho;
    private double r;
    protected static VonMises shared = new VonMises(1.0, AbstractDistribution.makeDefaultGenerator());

    public VonMises(double freedom, RandomElement randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(freedom);
    }

    public double nextDouble() {
        return this.nextDouble(this.my_k);
    }

    public double nextDouble(double k) {
        double v;
        double u;
        double z;
        double w;
        double c;
        if (k <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.k_set != k) {
            this.tau = 1.0 + Math.sqrt(1.0 + 4.0 * k * k);
            this.rho = (this.tau - Math.sqrt(2.0 * this.tau)) / (2.0 * k);
            this.r = (1.0 + this.rho * this.rho) / (2.0 * this.rho);
            this.k_set = k;
        }
        do {
            u = this.randomGenerator.raw();
            v = this.randomGenerator.raw();
        } while ((c = k * (this.r - (w = (1.0 + this.r * (z = Math.cos(Math.PI * u))) / (this.r + z)))) * (2.0 - c) < v && Math.log(c / v) + 1.0 < c);
        return this.randomGenerator.raw() > 0.5 ? Math.acos(w) : -Math.acos(w);
    }

    public void setState(double k) {
        if (k <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.my_k = k;
    }

    public static double staticNextDouble(double freedom) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            return shared.nextDouble(freedom);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.my_k + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomGenerator) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

