% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_model.v16.R
\name{c_helper}
\alias{c_helper}
\title{Contact rate function.}
\usage{
c_helper(
  rt_func = 1,
  st.inner = NULL,
  a1 = NULL,
  a2 = NULL,
  a3 = NULL,
  a4 = NULL,
  psi = NULL
)
}
\arguments{
\item{rt_func}{Options are:
\itemize{
  \item 1 - Two piece exponential.
  \item 2 - Exponential power model adapted from Granich et al. (2009)
  \item 3 - Mass action.
  \item 4 - Shifted inverse.
  \item 5 - Power.
  \item 6 - Poisson.
  \item 7 - Geometric.
}}

\item{st.inner}{The susceptible fraction \eqn{S_t}.}

\item{a1, a2, a3, a4}{Parameters of the contact rate curve specified by \code{rt_func};}

\item{psi}{A vector of same length as st.inner containing the corresponding psi restriction factor, or a scalar.}
}
\value{
The value of the contact rate, used to compute \eqn{R_t}.
}
\description{
Computes the c() function.
}
\details{
See Romanescu et al. (2023) for the exact forms of the functions.
}
