% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileHandlingFormats.R
\name{read_from_fluxnet15}
\alias{read_from_fluxnet15}
\title{extract REddyProc input columns from data.frame in Fluxnet15 format}
\usage{
read_from_fluxnet15(ds, colname_NEE = "NEE")
}
\arguments{
\item{ds}{data.frame with columns TIMESTAMP_END (Time YYYYMMDDHHMM),
NEE, LE, H, USTAR, TA, TS, VPD, SW_IN and optionally USTAR_QC}

\item{colname_NEE}{name (scalar string) of column that reports NEE observations}
}
\value{
data.frame with additional columns 'DateTime', 'NEE','Ustar' and
  'Rg','Tair','Tsoil' if columns 'SW_IN','TA', or 'TS' are present respectively
}
\description{
Column format as described at
https://fluxnet.org/data/fluxnet2015-dataset/fullset-data-product/
}
\details{
If input has numeric column USTAR_QC then USTAR of records
with USTAR_QC > 2 are set to NA.
}
