% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_vpd_from_dew.R
\name{estimate_vpd_from_dew}
\alias{estimate_vpd_from_dew}
\title{Estimate VPD from assuming dewpoint at daily minimum temperature}
\usage{
estimate_vpd_from_dew(df, pNonMissing = 0.1)
}
\arguments{
\item{df}{data.frame with columns DateTime, VPD, Tair, and Tair_f}

\item{pNonMissing}{numeric scalar of the necessary fraction of finite
VPD and Tair. If fraction is lower then a warning is thrown.}
}
\value{
numeric vector of length(nrow(data)) of estimated VPD
}
\description{
VPD is required for daytime NEE flux partitioning. Hence, it is necessary to
estimate VPD also for long gaps in data.
With two assumptions, VPD can be estimated from temperature
1). The change of water mass in air is negligible during the day.
VPD is the difference of actual vapour pressure to  saturation vapour pressure.
2.) At morning minimum temperature, vapour pressure is at minimum
in many cases at saturation.
Hence  \deqn{VPD = Esat(Tair) - E \approx Esat(Tair) - Esat_{daymin} \approx
Esat(Tair) - Esat(Tair_{min})}
}
\details{
Since sometimes Esat_daymin is lower than Esat(Tair_min)
the estimated VPDfromDew is underestimated. This function applies a
linear model of the existing VPD and estimated VPD to correct for this bias:
VPD ~ 0 + VPDfromDew * Tair_f * hourOfDay *  TminOftheDay * TRangeDay
}
