/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvarmulti;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvarmulti.RandomMultivariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class DirichletGen
extends RandomMultivariateGen {
    private GammaAcceptanceRejectionGen[] ggens;

    public DirichletGen(RandomStream randomStream, double[] dArray) {
        if (randomStream == null) {
            throw new NullPointerException("stream is null");
        }
        this.stream = randomStream;
        this.dist = null;
        this.dimension = dArray.length;
        this.ggens = new GammaAcceptanceRejectionGen[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.ggens[i] = new GammaAcceptanceRejectionGen(randomStream, new GammaDist(dArray[i], 0.5));
        }
    }

    public double getAlpha(int n) {
        return ((GammaDist)this.ggens[n].getDistribution()).getAlpha();
    }

    public static void nextPoint(RandomStream randomStream, double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = GammaAcceptanceRejectionGen.nextDouble(randomStream, randomStream, dArray[n], 0.5);
            d += dArray2[n];
        }
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] / d;
        }
    }

    public void nextPoint(double[] dArray) {
        int n;
        int n2 = this.ggens.length;
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.ggens[n].nextDouble();
            d += dArray[n];
        }
        n = 0;
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / d;
        }
    }
}

