/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public class SubsetOfPointSet
extends PointSet {
    protected PointSet P;
    protected int i_from;
    protected int i_to;
    protected int[] i_index;
    protected int j_from;
    protected int j_to;
    protected int[] j_index;

    public SubsetOfPointSet(PointSet pointSet) {
        this.P = pointSet;
        this.numPoints = pointSet.getNumPoints();
        this.dim = pointSet.getDimension();
        this.i_from = 0;
        this.i_to = pointSet.getNumPoints();
        this.j_from = 0;
        this.j_to = pointSet.getDimension();
    }

    public void selectPointsRange(int n, int n2) {
        if (0 > n || n >= n2 || n2 > this.P.getNumPoints()) {
            throw new IllegalArgumentException("Invalid range for points");
        }
        this.i_index = null;
        this.i_from = n;
        this.i_to = n2;
        this.numPoints = n2 - n;
    }

    public void selectPoints(int[] nArray, int n) {
        if (n > this.P.getNumPoints() || n > nArray.length) {
            throw new IllegalArgumentException("Number of indices too large");
        }
        this.i_index = nArray;
        this.numPoints = n;
    }

    public void selectCoordinatesRange(int n, int n2) {
        if (0 > n || n >= n2 || n2 > this.P.getDimension()) {
            throw new IllegalArgumentException("Invalid column range");
        }
        this.j_index = null;
        this.j_from = n;
        this.j_to = n2;
        this.dim = n2 - n;
    }

    public void selectCoordinates(int[] nArray, int n) {
        if (n > this.P.getDimension() || n > nArray.length) {
            throw new IllegalArgumentException("Number of indices too large");
        }
        this.j_index = nArray;
        this.dim = n;
    }

    public double getCoordinate(int n, int n2) {
        int n3;
        int n4;
        if (this.i_index == null) {
            if (n < 0 || n >= this.numPoints) {
                throw new IllegalArgumentException("Row out of range");
            }
            n4 = n + this.i_from;
        } else {
            n4 = this.i_index[n];
        }
        if (this.j_index == null) {
            if (n2 < 0 || n2 > this.dim) {
                throw new IllegalArgumentException("Column out of range");
            }
            n3 = n2 + this.j_from;
        } else {
            n3 = this.j_index[n2];
        }
        return this.P.getCoordinate(n4, n3);
    }

    public PointSetIterator iterator() {
        return new SubsetIterator();
    }

    public String toString() {
        int n;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("Subset of point set\n");
        stringBuffer.append("Inner point set information {\n");
        stringBuffer.append(this.P.toString());
        stringBuffer.append("\n}\n");
        if (this.i_index == null) {
            stringBuffer.append("Points range from " + this.i_from + " to " + this.i_to + ".\n");
        } else {
            stringBuffer.append("Point indices: [");
            bl = true;
            for (n = 0; n < this.numPoints; ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.i_index[n]);
            }
            stringBuffer.append("]\n");
        }
        if (this.j_index == null) {
            stringBuffer.append("Coordinates range from " + this.j_from + " to " + this.j_to + ".");
        } else {
            stringBuffer.append("Coordinate indices: [");
            bl = true;
            for (n = 0; n < this.dim; ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.j_index[n]);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private class SubsetIterator
    extends PointSet.DefaultPointSetIterator {
        private PointSetIterator innerIterator;

        SubsetIterator() {
            this.innerIterator = SubsetOfPointSet.this.P.iterator();
            if (SubsetOfPointSet.this.i_index == null) {
                if (SubsetOfPointSet.this.i_from != 0) {
                    this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_from);
                }
            } else if (SubsetOfPointSet.this.i_index[0] != 0) {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[0]);
            }
            if (SubsetOfPointSet.this.j_index == null) {
                if (SubsetOfPointSet.this.j_from != 0) {
                    this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_from);
                }
            } else if (SubsetOfPointSet.this.j_index[0] != 0) {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[0]);
            }
        }

        public void setCurCoordIndex(int n) {
            if (SubsetOfPointSet.this.j_index == null) {
                this.innerIterator.setCurCoordIndex(n + SubsetOfPointSet.this.j_from);
            } else {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[n]);
            }
            this.curCoordIndex = n;
        }

        public void resetCurCoordIndex() {
            if (SubsetOfPointSet.this.j_index == null) {
                if (SubsetOfPointSet.this.j_from == 0) {
                    this.innerIterator.resetCurCoordIndex();
                } else {
                    this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_from);
                }
            } else if (SubsetOfPointSet.this.j_index[0] == 0) {
                this.innerIterator.resetCurCoordIndex();
            } else {
                this.innerIterator.setCurCoordIndex(SubsetOfPointSet.this.j_index[0]);
            }
            this.curCoordIndex = 0;
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= SubsetOfPointSet.this.numPoints || this.curCoordIndex >= SubsetOfPointSet.this.dim) {
                this.outOfBounds();
            }
            double d = 0.0;
            if (SubsetOfPointSet.this.j_index == null) {
                d = this.innerIterator.nextCoordinate();
            } else {
                int n = SubsetOfPointSet.this.j_index[this.curCoordIndex];
                int n2 = this.curCoordIndex + 1 == SubsetOfPointSet.this.dim ? n + 1 : SubsetOfPointSet.this.j_index[this.curCoordIndex + 1];
                d = this.innerIterator.nextCoordinate();
                if (n2 != n + 1) {
                    this.innerIterator.setCurCoordIndex(n2);
                }
            }
            ++this.curCoordIndex;
            return d;
        }

        public void nextCoordinates(double[] dArray, int n) {
            if (this.curPointIndex >= SubsetOfPointSet.this.numPoints || this.curCoordIndex + n > SubsetOfPointSet.this.dim) {
                this.outOfBounds();
            }
            if (SubsetOfPointSet.this.j_index != null) {
                super.nextCoordinates(dArray, n);
                return;
            }
            this.innerIterator.nextCoordinates(dArray, n);
            this.curCoordIndex += n;
        }

        public void setCurPointIndex(int n) {
            if (SubsetOfPointSet.this.i_index == null) {
                this.innerIterator.setCurPointIndex(n + SubsetOfPointSet.this.i_from);
            } else {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[n]);
            }
            this.curPointIndex = n;
            this.resetCurCoordIndex();
        }

        public void resetCurPointIndex() {
            if (SubsetOfPointSet.this.i_index == null) {
                if (SubsetOfPointSet.this.i_from == 0) {
                    this.innerIterator.resetCurPointIndex();
                } else {
                    this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_from);
                }
            } else if (SubsetOfPointSet.this.i_index[0] == 0) {
                this.innerIterator.resetCurPointIndex();
            } else {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[0]);
            }
            this.curPointIndex = 0;
            this.resetCurCoordIndex();
        }

        public int resetToNextPoint() {
            if (SubsetOfPointSet.this.i_index == null) {
                this.innerIterator.resetToNextPoint();
            } else if (this.curPointIndex < SubsetOfPointSet.this.numPoints - 1) {
                this.innerIterator.setCurPointIndex(SubsetOfPointSet.this.i_index[this.curPointIndex + 1]);
            }
            ++this.curPointIndex;
            this.resetCurCoordIndex();
            return this.curPointIndex;
        }
    }
}

