% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit.R
\name{BIC.remix}
\alias{BIC.remix}
\title{BIC for remix object}
\usage{
\method{BIC}{remix}(object, ...)
}
\arguments{
\item{object}{output of \code{\link{remix}}.}

\item{...}{additional arguments.}
}
\value{
BIC.
}
\description{
Computes bayesian information criterion from the output of \code{\link{remix}} as
\deqn{BIC = -2\mathcal{LL}_{y}(\hat\theta,\hat\alpha)+\log(N)P}
where \eqn{P} is the total number of parameters estimated, \eqn{N} the number of subject and \eqn{\mathcal{LL}_{y}(\hat\theta,\hat\alpha)} the log-likelihood of the model.
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)
lambda = 1440

res = remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            eps2=1,
            lambda=lambda)

BIC(res)
}
}
\references{
Schwarz, G. 1978. Estimating the dimension of a model. The annals of statistics 6 (2): 461-464
}
