% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlREM.R
\name{controlREM}
\alias{controlREM}
\title{Control parameters for REM package}
\usage{
controlREM(
  steps = 25,
  tol = 1e-06,
  maxiter = 1000,
  min_weights = 1e-30,
  max_ueps = 0.3,
  chk_gamma = 0.9,
  n = 20000
)
}
\arguments{
\item{steps}{number of steps in binary search for optimal epsilon value (default = 25)}

\item{tol}{tolerance parameter to check for convergence of EM and REM algorithm (default = 1e-6)}

\item{maxiter}{maximum number iterations of EM and REM algorithm (default = 1e3)}

\item{min_weights}{lower bound for the individual weights estimated by REM (default = 1e-30)}

\item{max_ueps}{percentile of the distribution of likelihood values to use as the maximum epsilon value to consider}

\item{chk_gamma}{gamma value used when searching for epsilon}

\item{n}{sample size of simulated data used when checking heuristic criterion in the epsilon search}
}
\value{
control parameters used in the REM package (steps, tol, maxiter, min_weights, ueps, n).
}
\description{
Control parameters for REM package
}
\references{
Nieser, K. J., & Cochran, A. L. (2021). Addressing heterogeneous populations in latent variable settings through robust estimation. Psychological Methods.
}
\seealso{
\code{\link[=REM_EFA]{REM_EFA()}}, \code{\link[=REM_CFA]{REM_CFA()}}
}
\author{
Bryan Ortiz-Torres (bortiztorres@wisc.edu); Kenneth Nieser (nieser@stanford.edu)
}
