% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{TranscriptsPlot}
\alias{TranscriptsPlot}
\title{"TranscriptsPlot "}
\usage{
TranscriptsPlot(trans, positions, transcriptinfo, display.probesets = TRUE,
  Data, Groups = list(), Start = NULL, Stop = NULL, Highlight = NULL)
}
\arguments{
\item{trans}{The TC ID of the transcript to be plotted.}

\item{positions}{A table with the start and stop positions of the probe sets.}

\item{transcriptinfo}{A table with the transcript information of the TC ID.}

\item{display.probesets}{Logical. Should the probe sets be shown?}

\item{Data}{The exon level summarized data.}

\item{Groups}{A list with the groups (columns) of interest in the data.}

\item{Start}{Specify a specific start point on in the genome.}

\item{Stop}{Specify a specific stop point on in the genome.}

\item{Highlight}{A character string specifying a probe set to be highlighted in the transcript composition.}
}
\description{
The TranscriptsPlot function plots the known Ensemble transcript isoform composition plots.
}
\examples{
\dontrun{
data(positions_36)
data(transcript.clusters.NetAffx.36)
data(TC12000010_ExonLevel)
TranscriptsPlot(trans="TC12000010", display.probesets = TRUE,Data=TC12000010_ExonLevel,
Groups=list(c(10:18),c(19:27)),Start=NULL,Stop=NULL,Highlight="PSR12000150")
} 
}
