% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDSJunctionAssessment_HPCVersion}
\alias{REIDSJunctionAssessment_HPCVersion}
\title{REIDSJunctionAssessment_HPCVersion}
\usage{
REIDSJunctionAssessment_HPCVersion(geneID, DataS = DataS, ASPSR = ASPSR,
  Juninfo = "User", JAnnotI, JAnnot = NULL, EandTrAnnotI = NULL,
  EandTrAnnot = NULL, PartiallyAnnotated, positionData = NULL,
  transcriptData = NULL, Groups = list(), Low_AllSamples = c(),
  Low_GSamples = c(), Plot = FALSE)
}
\arguments{
\item{geneID}{The gene ID.}

\item{DataS}{The data with as rows the probesets and as columns the samples. Note that the first column should contain the gene IDs and the second column the exon IDs}

\item{ASPSR}{The AS probe sets as identified by ASExons.}

\item{Juninfo}{A parameter specifying wether the annotations are user of Ensembl defined. If JunInfo is "User" (default) the annotations provided in EandTrAnnot are used. If JunInfo is "Ensembl" the annotations in EandTrAnnot are used to set up tje junction associations but the gene name and position in transcriptData and positionData are used to connect with the Ensembl data base and retrieve corresponding information.}

\item{JAnnotI}{The file name with line indices for the junction associations.}

\item{JAnnot}{The file name with the junction associations.}

\item{EandTrAnnotI}{The file name with line indices for the exon and isoform annotations.}

\item{EandTrAnnot}{The file name with the exon and isoform annotations.}

\item{PartiallyAnnotated}{Logical. Should the exon annotations with partially annotated probe sets still be included? If FALSE, these are excluded. If TRUE, these are included. Default is FALSE.}

\item{positionData}{The file with the chromosome start and ends for the probe sets. Only needed in JunInfo=Ensembl.}

\item{transcriptData}{The file with gene name of the transcripts. Only needed in JunInfo=Ensembl.}

\item{Groups}{A list with  elements speficifing the columns of the data in each group.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Low_GSamples}{A list with a  character vector per group containing the probe sets which are not DABG in that group.}

\item{Plot}{Should a plot of the gene model be made?}
}
\value{
A .RData file will be saved for each gene with the four elements returned REIDSJunctionAssessment function. The outputs can be bound together by CreateOutput.
}
\description{
REIDSJunctionAssessment_HPCVersion is the HPC version of REIDSJunctionAssessment. This function should be used with the REIDSJunctionAssessment_HPCVersion.R file and REIDSJunctionAssessment_HPCVersion.pbs script in the documentation folder of the package.
After running this function on the cluster, the output files should be binded together with the CreateOutput function.
}
\details{
The plot is produced by the arcplot function of the arcdiagram package (https://github.com/gastonstat/arcdiagram)
}
