% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDSFunction_HPCVersion}
\alias{REIDSFunction_HPCVersion}
\title{"REIDS_HPCVersion"}
\usage{
REIDSFunction_HPCVersion(geneID, geneData, ASPSR = c(), nsim = 1000,
  informativeCalls = TRUE, Summarize = FALSE, rho = 0.5,
  Low_AllSamples = c())
}
\arguments{
\item{geneID}{The gene ID}

\item{geneData}{The data with as rows the probesets and as columns the samples. Note that the first column should contain the gene IDs and the second column the exon IDs}

\item{ASPSR}{A vector with alternatively spliced probe sets which are taken out of the analysis and summarization. This is useful if Summarize is "WeightedConst" and/or "EqualConst".}

\item{nsim}{The number of iterations to perform. Defaults to 1000.}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{Summarize}{A character vector specifying wich summarization method is to be performed. The choices are "EqualAll", "WeightedAll", "EqualConst" and "WeightedConst". The former two use all probe sets while the latter use only the constituitive probe sets. Summarization on the constistuitive probe sets will only be performed if ASPSR is specified.}

\item{rho}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than rho are kept.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}
}
\value{
A .RData file will be saved for each gene with the elements returned by the iniREIDS and REIDS functions. The outputs can be bound together by CreateOutput.
}
\description{
The REIDS_ClusterVersion performs the REIDS model and was adapted for use on a HPC cluster. This function should be used with the REIDS_HPCVersion.R file and REIDS_HPCVersion.pbs script in the documentation folder of the package.
After running this function on the cluster, the output files should be binded together with the CreateOutput function.
}
