% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDSFunction}
\alias{REIDSFunction}
\title{"REIDSFunction"}
\usage{
REIDSFunction(geneIDs, Name, Indices, DataFile, nsim = 5000,
  informativeCalls = TRUE, rho = 0.5, Low_AllSamples, Location)
}
\arguments{
\item{geneIDs}{A data frame with a "geneID" column.}

\item{Name}{A name for the returned list.}

\item{Indices}{The .csv file created by Line_Indexer.py which contains indices for every gene.}

\item{DataFile}{The .csv file created by PivotTransformation.}

\item{nsim}{The number of iterations to perform.}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{rho}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than rho are kept.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Location}{A character string indication the place where the outputs are saved.}
}
\value{
A list with an element for each gene with per gene the values returned by the iniREIDS and REIDS functions.
}
\description{
The REIDSFunction performs the REIDS model on the pivot transformed data by calling on the line indexed file. The REIDS model is performed gene by gene and the returned outputs are knitted together.
}
