% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ExpressionLevelPlot}
\alias{ExpressionLevelPlot}
\title{"ExpressionLevelPlot"}
\usage{
ExpressionLevelPlot(GeneID = NULL, ExonID = NULL, Data,
  GeneLevelData = NULL, ExonLevelData = NULL, Groups, ylabel = NULL,
  title = "")
}
\arguments{
\item{GeneID}{The gene ID of the gene of interest.}

\item{ExonID}{The exon ID of the exon of interest.}

\item{Data}{The processed data as returned by DataProcessing. This is were the observed probe intensities will be retrieved.}

\item{GeneLevelData}{The gene level summarized data to retrieve the gene level values.}

\item{ExonLevelData}{The exon level summarized data to retrieve the exon level values.}

\item{Groups}{The groups of interest in the data.}

\item{ylabel}{The label for the y-axis.}

\item{title}{A title for the plot.}
}
\description{
The ExpressionLevelPlot produces a plot of the expression levels of a specific exon and its corresponding gene.
}
\examples{
\dontrun{
data(TC12000010)
data(TC12000010_ExonLevel)
data(TC12000010_GeneLevel)
ExpressionLevelPlot(GeneID="TC12000010",ExonID="PSR12000150",
Data=TC12000010,GeneLevelData=TC12000010_GeneLevel,ExonLevelData
=TC12000010_ExonLevel,Groups=list(c(10:18),c(19:27)),ylabel="",
title="PSR12000150")
}
}
