% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_transform.R
\name{rd_transform}
\alias{rd_transform}
\title{Transformation of the raw data}
\usage{
rd_transform(
  ...,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  checkbox_labels = c("No", "Yes"),
  checkbox_na = FALSE,
  exclude_recalc = NULL,
  exclude_to_factor = NULL,
  delete_vars = NULL,
  delete_pattern = c("_complete", "_timestamp"),
  final_format = "raw",
  which_event = NULL,
  which_form = NULL,
  wide = NULL
)
}
\arguments{
\item{...}{Output of the function `redcap_data`, that is a list containing the data frames of the data, he dictionary and the event_form (if it's needed) of the REDCap project.}

\item{data}{Data frame containing the data read from REDCap. If the list is specified this argument is not necessary.}

\item{dic}{Data frame  containing the dictionary read from REDCap. If the list is specified this argument is not necessary.}

\item{event_form}{Data frame containing the correspondence of each event with each form. If the list is specified this argument is not necessary.}

\item{checkbox_labels}{Character vector with the names that will have the two options of every checkbox variable. Default is `c('No', 'Yes')`.}

\item{checkbox_na}{Logical indicating if values of checkboxes that have a branching logic have to set to missing only when the branching logic is missing (if set to false) or also when the branching logic isn't satisfied (if set to true). The default is false.}

\item{exclude_recalc}{Character vector with the names of the variables that do not have to be recalculated. Might be useful for projects were there are some calculated fields that have a time consuming recalculation.}

\item{exclude_to_factor}{Character vector with the names of the variables that do not have to be transformed to factors.}

\item{delete_vars}{Character vector specifying the variables to exclude.}

\item{delete_pattern}{Character vector specifying the regex pattern that will contain the variables to exclude. By default, variables ending up with `_complete` and `_timestamp` will be removed.}

\item{final_format}{Character string indicating the final arrangement format of the data that the function will return. Choose one of `raw`, `by_event` or `by_form`. `raw` (default) will return the transformed data with the original structure. `by_event` will return the transformed data as a nested data frame by event. `by_form` will return the transformed data as a nested data frame by form.}

\item{which_event}{Character string indicating if only one event has to be returned if the final format selected is `by_event`.}

\item{which_form}{Character string indicating if only one form has to be returned if the final format selected is `by_form`.}

\item{wide}{Logical indicating if the data split by form (if selected) has to be in a wide format or in a long one.}
}
\value{
List with the transformed dataset, dictionary, event_form and the results
}
\description{
Function that transforms the raw data from REDCap read by the function `redcap_data`. It returns the transformed data and dictionary along with the summary of the results of each step.
}
\examples{
rd_transform(covican)

# For customization of checkbox labels
rd_transform(covican,
             checkbox_labels = c("Not present", "Present"))

}
