% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{join}
\alias{join}
\alias{meet}
\alias{parallel}
\title{The join and meet of two points and the parallel}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
join(p, q)

meet(l, m)

parallel(p, l)
}
\arguments{
\item{p}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of a point.}

\item{q}{\eqn{(3 \times 1)} vectors of the homogeneous coordinates of a point.}

\item{l}{\eqn{(3 \times 1)} vectors of the homogeneous representation of a line.}

\item{m}{\eqn{(3 \times 1)} vectors of the homogeneous representation of a line.}
}
\value{
A \eqn{(3 \times 1)} vector of either the homogeneous coordinates of
 the meet of two lines (a point), the homogeneous representation of the 
 join of two points (line), or the homogeneous representation of the 
 parallel line. The vector has the form \eqn{(x,y,1)}.
}
\description{
The join operation of two points is the cross-product of these two points 
and represents the line passing through them. The meet operation of two lines 
is the cross-product of these two lines and represents their intersection. 
The line parallel to a line \eqn{l} and passing through the point \eqn{p} 
corresponds to the join of \eqn{p} with the meet of \eqn{l} and the line 
at infinity.
}
\examples{
p <- c(3,1,1)
q <- c(0,2,1)
l <- c(0.75,0.25,1)

# m is the line passin through p and q
m <- join(p,q)

# intersection point of m and l
ml <- meet(l,m)

# line parallel to l and through p
lp <- parallel(p,l)

# plot
plot(rbind(p,q),xlim=c(-5,5),ylim=c(-5,5))
abline(h=0,v=0,col="grey",lty=3)
addLine(l,col="red")
addLine(m,col="blue")
points(t(ml),cex=1.5,pch=20,col="blue")
addLine(lp,col="green")
}
