% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClickhouseDriver.R
\docType{class}
\name{ClickhouseDriver-class}
\alias{ClickhouseDriver-class}
\alias{clickhouse}
\alias{show,ClickhouseDriver-method}
\alias{dbGetInfo,ClickhouseDriver-method}
\alias{dbIsValid,ClickhouseDriver-method}
\alias{dbUnloadDriver,ClickhouseDriver-method}
\alias{loadConfig}
\alias{dbConnect,ClickhouseDriver-method}
\alias{dbDataType,ClickhouseDriver-method}
\title{Class ClickhouseDriver}
\usage{
clickhouse()

\S4method{show}{ClickhouseDriver}(object)

\S4method{dbGetInfo}{ClickhouseDriver}(dbObj, ...)

\S4method{dbIsValid}{ClickhouseDriver}(dbObj, ...)

\S4method{dbUnloadDriver}{ClickhouseDriver}(drv, ...)

loadConfig(CONFIG_PATHS, DEFAULT_PARAMS, pre_config)

\S4method{dbConnect}{ClickhouseDriver}(drv, host = "localhost", port = 9000,
  db = "default", user = "default", password = "", compression = "lz4",
  config_paths = c("./RClickhouse.yaml", "~/.R/RClickhouse.yaml",
  "/etc/RClickhouse.yaml"), ...)

\S4method{dbDataType}{ClickhouseDriver}(dbObj, obj, ...)
}
\arguments{
\item{drv}{ClickHouse database driver.}

\item{CONFIG_PATHS}{a list of configuration paths}

\item{DEFAULT_PARAMS}{a list of configuration defaults}

\item{pre_config}{initialization set}

\item{host}{name of the host on which the database is running.}

\item{port}{port on which the database is listening.}

\item{db}{name of the default database.}

\item{user}{name of the user to connect as.}

\item{password}{the user's password.}

\item{compression}{the compression method for the connection (lz4 by default).}

\item{config_paths}{paths where config files are searched for; order of paths denotes hierarchy (first string has highest priority etc.).}
}
\value{
a merged configuration

A database connection.
}
\description{
This driver never needs to be unloaded and hence \code{dbUnload()} is a
null-op.

Connect to a ClickHouse database.
}
\examples{
library(DBI)
RClickhouse::clickhouse()
\dontrun{
conn <- dbConnect(RClickhouse::clickhouse(), host="localhost")
}
}
\keyword{internal}
