% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{CredibleInterval}
\alias{CredibleInterval}
\title{Bayesian credible interval}
\usage{
CredibleInterval(a_chain, level = 0.95)
}
\arguments{
\item{a_chain}{numeric vector containing the output of the MCMC algorithm for a one-parameter}

\item{level}{probability corresponding to the level of confidence used for the credible interval}
}
\value{
Returns a vector of values containing the level of confidence and the endpoints of the shortest credible interval.
}
\description{
Computes the shortest credible interval at the desired level.
}
\details{
A (100 * level) \% credible intervalgives the shortest  interval, whose posterior probability is equal to the desired level.  This interval  is  approximated by constructing the shortest interval such that N*(1-level) elements of the sample are outside the interval.
}
\author{
Anne Philippe <Anne.Philippe@univ-nantes.fr> and

Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Events); attach(Events)

  CredibleInterval(Event.1)
  CredibleInterval(Event.12, 0.50)
}
\keyword{ credible interval }

