% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{plot_VCsquared}
\alias{plot_VCsquared}
\title{Plots expression(VC^2) along with the corresponding number of groups (orange), common factors (darkblue) and group factors of the first group (lightblue).}
\usage{
plot_VCsquared(
  VC_squared,
  rc,
  rcj,
  C_candidates,
  S_cand,
  xlim_min = 0.001,
  xlim_max = 100,
  add_true_lines = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{VC_squared}{measure of variability in the optimal configuration between the subsets}

\item{rc}{dataframe containg the numer of common factors for all candidate C's and all subsamples}

\item{rcj}{dataframe containg the numer of groupfactors for all candidate C's and all subsamples}

\item{C_candidates}{candidates for C (parameter in PIC)}

\item{S_cand}{candidate numbers for the number of groups}

\item{xlim_min}{starting point of the plot}

\item{xlim_max}{end point of the plot}

\item{add_true_lines}{if set to TRUE, for each C the true number of groups, common factors, and group specific factors of group 1 will be added to the plot}

\item{verbose}{if TRUE, more details are printed}
}
\value{
A ggplot object.
}
\description{
Plots expression(VC^2) along with the corresponding number of groups (orange), common factors (darkblue) and group factors of the first group (lightblue).
}
\examples{
\donttest{
set.seed(1)
#requires filled in dataframes rc and rcj
all_best_values <- calculate_best_config(add_configuration(initialise_df_results(TRUE),
  3, 0, c(3, 3, 3, rep(NA, 17))),
  data.frame(t(1:20)), 1:20)
rc <- fill_rc(initialise_rc(0:1, 1:20), all_best_values, 0)
rc <- fill_rc(rc, all_best_values, 1)
rcj <- fill_rcj(initialise_rcj(0:1, 1:20) , all_best_values, 0, 2:4, 2:4)
rcj <- fill_rcj(rcj, all_best_values, 1, 2:4, 2:4)
plot_VCsquared(c(runif(9), 0, 0, runif(9)), rc, rcj, 1:20, 2:4)
}
}
