% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_lgfg}
\alias{calculate_lgfg}
\title{Calculates the group factor structure: the matrix product of the group factors and their loadings.}
\usage{
calculate_lgfg(
  lambda_group,
  factor_group,
  S,
  k,
  kg,
  num_factors_may_vary,
  NN,
  TT
)
}
\arguments{
\item{lambda_group}{loadings of the estimated group specific factors}

\item{factor_group}{estimated group specific factors}

\item{S}{number of groups}

\item{k}{number of common factors}

\item{kg}{vector with the number of group specific factors for each group}

\item{num_factors_may_vary}{whether or not the number of groupfactors is constant over all groups or not}

\item{NN}{number of time series}

\item{TT}{length of time series}
}
\value{
list with S elements: each element contains a matrix with NN rows and TT columns with the estimated group factor structure of this particular group
}
\description{
Returns list (with as length the number of groups) with lgfg (product of grouploadings and groupfactors).
Each element of the list with the assumption that all individuals are in the same group k.
This function is used to speed up code.
}
