#' Generates random sample of nationally representative surnames
#'
#' @description Generates a random sample of surnames of any length. Surnames and probabilities from Census Bureau, see <https://www.census.gov/topics/population/genealogy/data/2010_surnames.html>. Used to illustrate random sampling methods.
#' @param n The number of random surnames to be generated
#' @return A vector of surnames
#' @examples 
#'    library(RCPA3)
#'    
#'    random.names(10)
#' @export
#' @section RCPA3 Package Tutorial Videos:
#' * [Complete Playlist of RCPA3 Package Tutorial Videos](https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu), includes video for this function and many more. 
#' @keywords internal
#'
random.names<-function(n)
{
  
popular.names <- c("SMITH", "JOHNSON", "WILLIAMS", "BROWN", "JONES", "GARCIA", "MILLER", "DAVIS", "RODRIGUEZ", "MARTINEZ", "HERNANDEZ", "LOPEZ", "GONZALEZ", "WILSON",
"ANDERSON", "THOMAS", "TAYLOR", "MOORE", "JACKSON", "MARTIN", "LEE", "PEREZ", "THOMPSON", "WHITE", "HARRIS", "SANCHEZ", "CLARK", "RAMIREZ",
"LEWIS", "ROBINSON", "WALKER", "YOUNG", "ALLEN", "KING", "WRIGHT", "SCOTT", "TORRES", "NGUYEN", "HILL", "FLORES", "GREEN", "ADAMS",
"NELSON", "BAKER", "HALL", "RIVERA", "CAMPBELL", "MITCHELL", "CARTER", "ROBERTS", "GOMEZ", "PHILLIPS", "EVANS", "TURNER", "DIAZ", "PARKER",
"CRUZ", "EDWARDS", "COLLINS", "REYES", "STEWART", "MORRIS", "MORALES", "MURPHY", "COOK", "ROGERS", "GUTIERREZ", "ORTIZ", "MORGAN", "COOPER",
"PETERSON", "BAILEY", "REED", "KELLY", "HOWARD", "RAMOS", "KIM", "COX", "WARD", "RICHARDSON", "WATSON", "BROOKS", "CHAVEZ", "WOOD",
"JAMES", "BENNETT", "GRAY", "MENDOZA", "RUIZ", "HUGHES", "PRICE", "ALVAREZ", "CASTILLO", "SANDERS", "PATEL", "MYERS", "LONG", "ROSS",
"FOSTER", "JIMENEZ", "POWELL", "JENKINS", "PERRY", "RUSSELL", "SULLIVAN", "BELL", "COLEMAN", "BUTLER", "HENDERSON", "BARNES", "GONZALES", "FISHER",
"VASQUEZ", "SIMMONS", "ROMERO", "JORDAN", "PATTERSON", "ALEXANDER", "HAMILTON", "GRAHAM", "REYNOLDS", "GRIFFIN", "WALLACE", "MORENO", "WEST", "COLE",
"HAYES", "BRYANT", "HERRERA", "GIBSON", "ELLIS", "TRAN", "MEDINA", "AGUILAR", "STEVENS", "MURRAY", "FORD", "CASTRO", "MARSHALL", "OWENS",
"HARRISON", "FERNANDEZ", "MCDONALD", "WOODS", "WASHINGTON", "KENNEDY", "WELLS", "VARGAS", "HENRY", "CHEN", "FREEMAN", "WEBB", "TUCKER", "GUZMAN",
"BURNS", "CRAWFORD", "OLSON", "SIMPSON", "PORTER", "HUNTER", "GORDON", "MENDEZ", "SILVA", "SHAW", "SNYDER", "MASON", "DIXON", "MUNOZ",
"HUNT", "HICKS", "HOLMES", "PALMER", "WAGNER", "BLACK", "ROBERTSON", "BOYD", "ROSE", "STONE", "SALAZAR", "FOX", "WARREN", "MILLS",
"MEYER", "RICE", "SCHMIDT", "GARZA", "DANIELS", "FERGUSON", "NICHOLS", "STEPHENS", "SOTO", "WEAVER", "RYAN", "GARDNER", "PAYNE", "GRANT",
"DUNN", "KELLEY", "SPENCER", "HAWKINS", "ARNOLD", "PIERCE", "VAZQUEZ", "HANSEN", "PETERS", "SANTOS", "HART", "BRADLEY", "KNIGHT", "ELLIOTT",
"CUNNINGHAM", "DUNCAN", "ARMSTRONG", "HUDSON", "CARROLL", "LANE", "RILEY", "ANDREWS", "ALVARADO", "RAY", "DELGADO", "BERRY", "PERKINS", "HOFFMAN",
"JOHNSTON", "MATTHEWS", "PENA", "RICHARDS", "CONTRERAS", "WILLIS", "CARPENTER", "LAWRENCE", "SANDOVAL", "GUERRERO", "GEORGE", "CHAPMAN", "RIOS", "ESTRADA",
"ORTEGA", "WATKINS", "GREENE", "NUNEZ", "WHEELER", "VALDEZ", "HARPER", "BURKE", "LARSON", "SANTIAGO", "MALDONADO", "MORRISON", "FRANKLIN", "CARLSON",
"AUSTIN", "DOMINGUEZ", "CARR", "LAWSON", "JACOBS", "OBRIEN", "LYNCH", "SINGH", "VEGA", "BISHOP", "MONTGOMERY", "OLIVER", "JENSEN", "HARVEY",
"WILLIAMSON", "GILBERT", "DEAN", "SIMS", "ESPINOZA", "HOWELL", "LI", "WONG", "REID", "HANSON", "LE", "MCCOY", "GARRETT", "BURTON",
"FULLER", "WANG", "WEBER", "WELCH", "ROJAS", "LUCAS", "MARQUEZ", "FIELDS", "PARK", "YANG", "LITTLE", "BANKS", "PADILLA", "DAY",
"WALSH", "BOWMAN", "SCHULTZ", "LUNA", "FOWLER", "MEJIA", "DAVIDSON", "ACOSTA", "BREWER", "MAY", "HOLLAND", "JUAREZ", "NEWMAN", "PEARSON",
"CURTIS", "CORTEZ", "DOUGLAS", "SCHNEIDER", "JOSEPH", "BARRETT", "NAVARRO", "FIGUEROA", "KELLER", "AVILA", "WADE", "MOLINA", "STANLEY", "HOPKINS",
"CAMPOS", "BARNETT", "BATES", "CHAMBERS", "CALDWELL", "BECK", "LAMBERT", "MIRANDA", "BYRD", "CRAIG", "AYALA", "LOWE", "FRAZIER", "POWERS",
"NEAL", "LEONARD", "GREGORY", "CARRILLO", "SUTTON", "FLEMING", "RHODES", "SHELTON", "SCHWARTZ", "NORRIS", "JENNINGS", "WATTS", "DURAN", "WALTERS",
"COHEN", "MCDANIEL", "MORAN", "PARKS", "STEELE", "VAUGHN", "BECKER", "HOLT", "DELEON", "BARKER", "TERRY", "HALE", "LEON", "HAIL",
"BENSON", "HAYNES", "HORTON", "MILES", "LYONS", "PHAM", "GRAVES", "BUSH", "THORNTON", "WOLFE", "WARNER", "CABRERA", "MCKINNEY", "MANN",
"ZIMMERMAN", "DAWSON", "LARA", "FLETCHER", "PAGE", "MCCARTHY", "LOVE", "ROBLES", "CERVANTES", "SOLIS", "ERICKSON", "REEVES", "CHANG", "KLEIN",
"SALINAS", "FUENTES", "BALDWIN", "DANIEL", "SIMON", "VELASQUEZ", "HARDY", "HIGGINS", "AGUIRRE", "LIN", "CUMMINGS", "CHANDLER", "SHARP", "BARBER",
"BOWEN", "OCHOA", "DENNIS", "ROBBINS", "LIU", "RAMSEY", "FRANCIS", "GRIFFITH", "PAUL", "BLAIR", "OCONNOR", "CARDENAS", "PACHECO", "CROSS",
"CALDERON", "QUINN", "MOSS", "SWANSON", "CHAN", "RIVAS", "KHAN", "RODGERS", "SERRANO", "FITZGERALD", "ROSALES", "STEVENSON", "CHRISTENSEN", "MANNING",
"GILL", "CURRY", "MCLAUGHLIN", "HARMON", "MCGEE", "GROSS", "DOYLE", "GARNER", "NEWTON", "BURGESS", "REESE", "WALTON", "BLAKE", "TRUJILLO",
"ADKINS", "BRADY", "GOODMAN", "ROMAN", "WEBSTER", "GOODWIN", "FISCHER", "HUANG", "POTTER", "DELACRUZ", "MONTOYA", "TODD", "WU", "HINES",
"MULLINS", "CASTANEDA", "MALONE", "CANNON", "TATE", "MACK", "SHERMAN", "HUBBARD", "HODGES", "ZHANG", "GUERRA", "WOLF", "VALENCIA", "SAUNDERS",
"FRANCO", "ROWE", "GALLAGHER", "FARMER", "HAMMOND", "HAMPTON", "TOWNSEND", "INGRAM", "WISE", "GALLEGOS", "CLARKE", "BARTON", "SCHROEDER", "MAXWELL",
"WATERS", "LOGAN", "CAMACHO", "STRICKLAND", "NORMAN", "PERSON", "COLON", "PARSONS", "FRANK", "HARRINGTON", "GLOVER", "OSBORNE", "BUCHANAN", "CASEY",
"FLOYD", "PATTON", "IBARRA", "BALL", "TYLER", "SUAREZ", "BOWERS", "OROZCO", "SALAS", "COBB", "GIBBS", "ANDRADE", "BAUER", "CONNER",
"MOODY", "ESCOBAR", "MCGUIRE", "LLOYD", "MUELLER", "HARTMAN", "FRENCH", "KRAMER", "MCBRIDE", "POPE", "LINDSEY", "VELAZQUEZ", "NORTON", "MCCORMICK",
"SPARKS", "FLYNN", "YATES", "HOGAN", "MARSH", "MACIAS", "VILLANUEVA", "ZAMORA", "PRATT", "STOKES", "OWEN", "BALLARD", "LANG", "BROCK",
"VILLARREAL", "CHARLES", "DRAKE", "BARRERA", "CAIN", "PATRICK", "PINEDA", "BURNETT", "MERCADO", "SANTANA", "SHEPHERD", "BAUTISTA", "ALI", "SHAFFER",
"LAMB", "TREVINO", "MCKENZIE", "HESS", "BEIL", "OLSEN", "COCHRAN", "MORTON", "NASH", "WILKINS", "PETERSEN", "BRIGGS", "SHAH", "ROTH",
"NICHOLSON", "HOLLOWAY", "LOZANO", "RANGEL", "FLOWERS", "HOOVER", "SHORT", "ARIAS", "MORA", "VALENZUELA", "BRYAN", "MEYERS", "WEISS", "UNDERWOOD",
"BASS", "GREER", "SUMMERS", "HOUSTON", "CARSON", "MORROW", "CLAYTON", "WHITAKER", "DECKER", "YODER", "COLLIER", "ZUNIGA", "CAREY", "WILCOX",
"MELENDEZ", "POOLE", "ROBERSON", "LARSEN", "CONLEY", "DAVENPORT", "COPELAND", "MASSEY", "LAM", "HUFF", "ROCHA", "CAMERON", "JEFFERSON", "HOOD",
"MONROE", "ANTHONY", "PITTMAN", "HUYNH", "RANDALL", "SINGLETON", "KIRK", "COMBS", "MATHIS", "CHRISTIAN", "SKINNER", "BRADFORD", "RICHARD", "GALVAN",
"WALL", "BOONE", "KIRBY", "WILKINSON", "BRIDGES", "BRUCE", "ATKINSON", "VELEZ", "MEZA", "ROY", "VINCENT", "YORK", "HODGE", "VILLA",
"ABBOTT", "ALLISON", "TAPIA", "GATES", "CHASE", "SOSA", "SWEENEY", "FARRELL", "WYATT", "DALTON", "HORN", "BARRON", "PHELPS", "YU",
"DICKERSON", "HEATH", "FOLEY", "ATKINS", "MATHEWS", "BONILLA", "ACEVEDO", "BENITEZ", "ZAVALA", "HENSLEY", "GLENN", "CISNEROS", "HARRELL", "SHIELDS",
"RUBIO", "HUFFMAN", "CHOI", "BOYER", "GARRISON", "ARROYO", "BOND", "KANE", "HANCOCK", "CALLAHAN", "DILLON", "CLINE", "WIGGINS", "GRIMES",
"ARELLANO", "MELTON", "ONEILL", "SAVAGE", "HO", "BELTRAN", "PITTS", "PARRISH", "PONCE", "RICH", "BOOTH", "KOCH", "GOLDEN", "WARE",
"BRENNAN", "MCDOWELL", "MARKS", "CANTU", "HUMPHREY", "BAXTER", "SAWYER", "CLAY", "TANNER", "HUTCHINSON", "KAUR", "BERG", "WILEY", "GILMORE",
"RUSSO", "VILLEGAS", "HOBBS", "KEITH", "WILKERSON", "AHMED", "BEARD", "MCCLAIN", "MONTES", "MATA", "ROSARIO", "VANG", "WALTER", "HENSON",
"ONEAL", "MOSLEY", "MCCLURE", "BEASLEY", "STEPHENSON", "SNOW", "HUERTA", "PRESTON", "VANCE", "BARRY", "JOHNS", "EATON", "BLACKWELL", "DYER",
"PRINCE", "MACDONALD", "SOLOMON", "GUEVARA", "STAFFORD", "ENGLISH", "HURST", "WOODARD", "CORTES", "SHANNON", "KEMP", "NOLAN", "MCCULLOUGH", "MERRITT",
"MURILLO", "MOON", "SALGADO", "STRONG", "KLINE", "CORDOVA", "BARAJAS", "ROACH", "ROSAS", "WINTERS", "JACOBSON", "LESTER", "KNOX", "BULLOCK",
"KERR", "LEACH", "MEADOWS", "ORR", "DAVILA", "WHITEHEAD", "PRUITT", "KENT", "CONWAY", "MCKEE", "BARR", "DAVID", "DEJESUS", "MARIN",
"BERGER", "MCINTYRE", "BLANKENSHIP", "GAINES", "PALACIOS", "CUEVAS", "BARTLETT", "DURHAM", "DORSEY", "MCCALL", "ODONNELL", "STEIN", "BROWNING", "STOUT",
"LOWERY", "SLOAN", "MCLEAN", "HENDRICKS", "CALHOUN", "SEXTON", "CHUNG", "GENTRY", "HULL", "DUARTE", "ELLISON", "NIELSEN", "GILLESPIE", "BUCK",
"MIDDLETON", "SELLERS", "LEBLANC", "ESPARZA", "HARDIN", "BRADSHAW", "MCINTOSH", "HOWE", "LIVINGSTON", "FROST", "GLASS", "MORSE", "KNAPP", "HERMAN",
"STARK", "BRAVO", "NOBLE", "SPEARS", "WEEKS", "CORONA", "FREDERICK", "BUCKLEY", "MCFARLAND", "HEBERT", "ENRIQUEZ", "HICKMAN", "QUINTERO", "RANDOLPH",
"SCHAEFER", "WALLS", "TREJO", "HOUSE", "REILLY", "PENNINGTON", "MICHAEL", "CONRAD", "GILES", "BENJAMIN", "CROSBY", "FITZPATRICK", "DONOVAN", "MAYS",
"MAHONEY", "VALENTINE", "RAYMOND", "MEDRANO", "HAHN", "MCMILLAN", "SMALL", "BENTLEY", "FELIX", "PECK", "LUCERO", "BOYLE", "HANNA", "PACE",
"RUSH", "HURLEY", "HARDING", "MCCONNELL", "BERNAL", "NAVA", "AYERS", "EVERETT", "VENTURA", "AVERY", "PUGH", "MAYER", "BENDER", "SHEPARD",
"MCMAHON", "LANDRY", "CASE", "SAMPSON", "MOSES", "MAGANA", "BLACKBURN", "DUNLAP", "GOULD", "DUFFY", "VAUGHAN", "HERRING", "MCKAY", "ESPINOSA",
"RIVERS", "FARLEY", "BERNARD", "ASHLEY", "FRIEDMAN", "POTTS", "TRUONG", "COSTA", "CORREA", "BLEVINS", "NIXON", "CLEMENTS", "FRY", "DELAROSA",
"BEST", "BENTON", "LUGO", "PORTILLO", "DOUGHERTY", "CRANE", "HALEY", "PHAN", "VILLALOBOS", "BLANCHARD", "HORNE", "FINLEY", "QUINTANA", "LYNN",
"ESQUIVEL", "BEAN", "DODSON", "MULLEN", "XIONG", "HAYDEN", "CANO", "LEVY", "HUBER", "RICHMOND", "MOYER", "LIM", "FRYE", "SHEPPARD",
"MCCARTY", "AVALOS", "BOOKER", "WALLER", "PARRA", "WOODWARD", "JARAMILLO", "KRUEGER", "RASMUSSEN", "BRANDT", "PERALTA", "DONALDSON", "STUART", "FAULKNER",
"MAYNARD", "GALINDO", "COFFEY", "ESTES", "SANFORD", "BURCH", "MADDOX", "VO", "OCONNELL", "VU", "ANDERSEN", "SPENCE", "MCPHERSON", "CHURCH",
"SCHMITT", "STANTON", "LEAL", "CHERRY", "COMPTON", "DUDLEY", "SIERRA", "POLLARD", "ALFARO", "HESTER", "PROCTOR", "LU", "HINTON", "NOVAK",
"GOOD", "MADDEN", "MCCANN", "TERRELL", "JARVIS", "DICKSON", "REYNA", "CANTRELL", "MAYO", "BRANCH", "HENDRIX", "ROLLINS", "ROWLAND", "WHITNEY",
"DUKE", "ODOM", "DAUGHERTY", "TRAVIS", "TANG", "ARCHER")

per100k <- c(828.2, 655.2, 551.0, 487.2, 483.2, 395.3, 393.7, 378.5, 371.2, 359.4, 353.7, 296.5, 285.1, 271.8, 265.9, 256.3, 254.7,
245.6, 240.1, 238.2, 234.9, 231.1, 225.3, 223.9, 211.6, 207.7, 190.8, 189.0, 180.3, 179.6, 177.3, 164.2, 163.6, 157.8,
155.6, 149.0, 148.4, 148.4, 147.4, 147.1, 145.8, 145.1, 144.1, 142.2, 138.0, 132.6, 130.9, 130.3, 127.8, 127.7, 124.0,
122.3, 120.6, 118.2, 117.9, 114.0, 113.3, 112.7, 111.8, 111.2, 110.2, 108.1, 105.7, 104.6, 102.6, 102.5, 99.4, 97.3,
97.1, 95.2, 94.3, 94.2, 93.9, 90.7, 89.8, 89.3, 88.9, 88.6, 88.3, 88.1, 85.6, 85.3, 85.1, 85.0, 84.5,
83.9, 83.4, 82.3, 80.8, 80.1, 79.8, 79.3, 78.1, 78.1, 78.0, 77.9, 77.8, 77.8, 77.2, 77.0, 76.2, 75.5,
75.2, 75.1, 74.9, 74.8, 74.3, 74.2, 74.0, 74.0, 72.8, 72.8, 72.1, 71.3, 70.7, 70.7, 69.6, 69.4, 68.4,
68.2, 67.9, 67.3, 66.9, 66.8, 66.4, 66.2, 65.9, 65.4, 65.3, 64.6, 64.1, 63.9, 63.9, 63.2, 62.9, 62.7,
62.7, 62.4, 62.4, 61.9, 61.4, 61.3, 61.2, 60.2, 60.1, 60.0, 59.7, 58.9, 58.0, 57.5, 57.3, 57.3, 56.8,
56.6, 56.3, 55.8, 55.6, 55.3, 55.3, 55.1, 54.9, 54.8, 54.8, 54.4, 54.3, 54.3, 54.1, 53.7, 53.7, 53.7,
53.2, 53.1, 52.8, 52.5, 52.1, 52.0, 52.0, 52.0, 51.8, 51.6, 51.6, 51.5, 51.2, 50.7, 49.9, 49.8, 49.7,
49.6, 49.4, 49.0, 49.0, 48.8, 48.6, 48.4, 48.3, 48.2, 47.9, 47.7, 47.4, 47.4, 47.1, 47.0, 46.9, 46.8,
46.6, 46.5, 46.5, 46.4, 46.4, 46.0, 46.0, 45.8, 45.8, 45.8, 45.5, 45.5, 45.4, 45.4, 45.3, 45.2, 45.1,
45.0, 44.6, 44.6, 44.5, 44.5, 44.3, 44.3, 44.1, 44.1, 44.0, 44.0, 43.7, 43.6, 43.6, 43.4, 43.3, 43.2,
43.1, 43.1, 42.8, 42.5, 42.4, 42.4, 42.2, 41.7, 41.6, 41.4, 41.2, 41.1, 40.9, 40.9, 40.6, 40.4, 40.4,
40.4, 40.2, 40.2, 39.9, 39.6, 39.6, 39.5, 39.3, 39.3, 39.2, 39.2, 39.0, 39.0, 38.7, 38.4, 38.0, 38.0,
37.9, 37.8, 37.8, 37.7, 37.6, 37.5, 37.5, 37.5, 37.3, 37.3, 37.1, 37.0, 36.8, 36.5, 36.5, 36.5, 36.2,
36.0, 35.9, 35.9, 35.7, 35.6, 35.6, 35.6, 35.6, 35.4, 35.4, 35.3, 35.2, 35.1, 35.0, 35.0, 34.8, 34.6,
34.6, 34.5, 34.5, 34.5, 34.4, 34.3, 34.2, 33.9, 33.8, 33.4, 33.3, 33.0, 32.9, 32.9, 32.8, 32.8, 32.6,
32.4, 32.4, 32.2, 31.9, 31.8, 31.8, 31.7, 31.5, 31.4, 31.4, 31.3, 31.2, 31.2, 31.1, 31.0, 31.0, 30.9,
30.8, 30.7, 30.7, 30.7, 30.5, 30.4, 30.4, 30.4, 30.3, 30.3, 30.2, 30.1, 30.0, 30.0, 29.9, 29.9, 29.8,
29.7, 29.6, 29.6, 29.5, 29.4, 29.3, 29.2, 29.2, 29.2, 28.9, 28.8, 28.7, 28.6, 28.5, 28.5, 28.5, 28.5,
28.4, 28.4, 28.4, 28.3, 28.2, 28.2, 28.2, 28.2, 28.1, 28.1, 28.1, 28.0, 27.9, 27.9, 27.8, 27.8, 27.8,
27.6, 27.5, 27.5, 27.4, 27.3, 27.3, 27.2, 27.2, 27.1, 27.0, 27.0, 26.9, 26.8, 26.8, 26.7, 26.7, 26.7,
26.6, 26.6, 26.6, 26.6, 26.6, 26.5, 26.5, 26.5, 26.4, 26.3, 26.3, 26.3, 26.1, 26.1, 26.1, 26.1, 26.0,
25.8, 25.8, 25.8, 25.8, 25.6, 25.5, 25.5, 25.5, 25.4, 25.4, 25.4, 25.4, 25.3, 25.3, 25.3, 25.2, 25.2,
25.1, 25.1, 25.1, 25.0, 25.0, 25.0, 25.0, 24.8, 24.8, 24.7, 24.6, 24.6, 24.5, 24.5, 24.5, 24.5, 24.4,
24.3, 24.3, 24.3, 24.3, 24.2, 24.2, 24.1, 24.1, 24.1, 23.9, 23.9, 23.8, 23.8, 23.8, 23.7, 23.7, 23.7,
23.7, 23.7, 23.7, 23.6, 23.6, 23.6, 23.5, 23.5, 23.3, 23.2, 23.2, 23.1, 23.0, 23.0, 23.0, 23.0, 23.0,
23.0, 23.0, 22.9, 22.8, 22.8, 22.8, 22.7, 22.7, 22.7, 22.6, 22.6, 22.5, 22.5, 22.4, 22.4, 22.4, 22.4,
22.4, 22.3, 22.2, 22.1, 22.1, 22.1, 22.0, 21.9, 21.8, 21.8, 21.8, 21.8, 21.8, 21.7, 21.7, 21.7, 21.7,
21.7, 21.6, 21.6, 21.6, 21.6, 21.5, 21.5, 21.4, 21.4, 21.1, 21.1, 21.0, 20.9, 20.9, 20.9, 20.9, 20.9,
20.9, 20.8, 20.8, 20.8, 20.7, 20.7, 20.7, 20.6, 20.6, 20.6, 20.6, 20.6, 20.5, 20.4, 20.3, 20.3, 20.3,
20.3, 20.2, 20.2, 20.2, 20.1, 20.1, 20.1, 19.9, 19.9, 19.8, 19.8, 19.8, 19.8, 19.7, 19.7, 19.6, 19.5,
19.5, 19.5, 19.5, 19.5, 19.5, 19.5, 19.4, 19.4, 19.4, 19.4, 19.3, 19.3, 19.3, 19.3, 19.3, 19.3, 19.2,
19.2, 19.2, 19.1, 19.1, 19.1, 19.1, 19.1, 19.1, 19.1, 19.1, 19.0, 19.0, 19.0, 18.9, 18.9, 18.8, 18.8,
18.7, 18.7, 18.7, 18.7, 18.7, 18.7, 18.7, 18.6, 18.6, 18.5, 18.4, 18.4, 18.4, 18.4, 18.3, 18.3, 18.3,
18.3, 18.2, 18.2, 18.2, 18.2, 18.2, 18.1, 18.1, 18.1, 18.1, 18.0, 18.0, 18.0, 17.9, 17.9, 17.9, 17.9,
17.9, 17.8, 17.8, 17.8, 17.8, 17.7, 17.7, 17.7, 17.7, 17.7, 17.6, 17.6, 17.6, 17.6, 17.6, 17.5, 17.5,
17.5, 17.4, 17.4, 17.3, 17.3, 17.3, 17.3, 17.2, 17.2, 17.2, 17.2, 17.2, 17.2, 17.2, 17.2, 17.2, 17.2,
17.1, 17.1, 17.1, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 16.9, 16.9, 16.9, 16.9, 16.9, 16.8, 16.8, 16.8,
16.8, 16.7, 16.7, 16.7, 16.7, 16.7, 16.7, 16.6, 16.6, 16.6, 16.6, 16.6, 16.5, 16.5, 16.5, 16.5, 16.5,
16.5, 16.5, 16.5, 16.4, 16.4, 16.4, 16.3, 16.3, 16.3, 16.3, 16.3, 16.3, 16.3, 16.3, 16.3, 16.3, 16.2,
16.2, 16.2, 16.1, 16.1, 16.1, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 15.8, 15.8, 15.8, 15.7, 15.7,
15.7, 15.7, 15.7, 15.6, 15.6, 15.6, 15.5, 15.5, 15.4, 15.4, 15.4, 15.4, 15.4, 15.4, 15.3, 15.3, 15.2,
15.2, 15.2, 15.2, 15.2, 15.2, 15.2, 15.1, 15.1, 15.1, 15.1, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 14.9,
14.9, 14.9, 14.9, 14.9, 14.9, 14.9, 14.9, 14.8, 14.8, 14.8, 14.8, 14.7, 14.7, 14.7, 14.7, 14.7, 14.7,
14.7, 14.7, 14.6, 14.6, 14.6, 14.6, 14.6, 14.6, 14.6, 14.5, 14.5, 14.5, 14.5, 14.4, 14.4, 14.4, 14.4,
14.4, 14.4, 14.4, 14.3, 14.3, 14.2, 14.2, 14.2, 14.2, 14.2, 14.2, 14.1, 14.1, 14.1, 14.1, 14.1, 14.0,
14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 13.9, 13.9, 13.9, 13.9, 13.9, 13.9, 13.9, 13.8, 13.8, 13.8, 13.8,
13.8, 13.7, 13.7, 13.7, 13.7, 13.7, 13.7, 13.7, 13.7, 13.6, 13.6, 13.6, 13.6, 13.6, 13.6, 13.5, 13.5,
13.5, 13.5, 13.5, 13.5, 13.5, 13.5, 13.5, 13.4, 13.4, 13.4, 13.4, 13.4, 13.4, 13.4, 13.4, 13.4, 13.4,
13.3, 13.3, 13.3, 13.3, 13.3, 13.2, 13.2, 13.2, 13.2, 13.1, 13.1, 13.1, 13.1, 13.1, 13.1, 13.1, 13.0,
13.0, 13.0, 13.0, 13.0, 13.0, 12.9, 12.9, 12.9, 12.9, 12.9, 12.9, 12.9, 12.8, 12.8, 12.8, 12.8, 12.8,
12.8, 12.8, 12.8, 12.8, 12.8, 12.8, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.6, 12.6, 12.6, 12.6,
12.6, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4,
12.4, 12.4, 12.4, 12.3, 12.3, 12.3, 12.3, 12.3, 12.3, 12.3, 12.3, 12.3, 12.3, 12.2, 12.2, 12.2, 12.2,
12.2, 12.2, 12.1, 12.1, 12.1, 12.1, 12.1, 12.1, 12.1, 12.1, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0,
12.0, 12.0, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9, 11.9)


sample(popular.names, size=n, replace=T, prob=per100k/sum(per100k))

}

