% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{runPathwayMetaAnalysis}
\alias{runPathwayMetaAnalysis}
\title{Perform Meta Analysis}
\usage{
runPathwayMetaAnalysis(
  PAResults,
  method = c("stouffer", "fisher", "addCLT", "geoMean", "minP", "REML")
)
}
\arguments{
\item{PAResults}{A list of at least size two of data frames obtained from pathway analysis}

\item{method}{A method used to combine pathway analysis results, which can be "stouffer", "fisher", "addCLT", "geoMean", "minP", or "REML"}
}
\value{
A dataframe of meta analysis results including the following columns:
\itemize{
\item{ID: The ID of pathway}
\item{name: The name of pathway}
\item{p.value: The meta p-value of pathway}
\item{pFDR: The adjusted meta p-value of pathway using Benjamini-Hochberg method}
\item{score: The combined score of pathway}
\item{normalizedScore: The combined normalized score of pathway}
\item{pathwaySize: The size of pathway}
}
}
\description{
This function performs meta analysis on multiple pathway analysis results.
}
\details{
This function performs meta-analysis on multiple pathway analysis results.
}
\examples{
\donttest{

library(RCPA)
affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")

metaPAResult <- RCPA::runPathwayMetaAnalysis(
    list(affyFgseaResult, agilFgseaResult, RNASeqFgseaResult),
    method = "stouffer"
)
}
}
