% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{runPathwayMetaAnalysis}
\alias{runPathwayMetaAnalysis}
\title{Perform Meta Analysis}
\usage{
runPathwayMetaAnalysis(
  PAResults,
  method = c("stouffer", "fisher", "addCLT", "geoMean", "minP", "REML")
)
}
\arguments{
\item{PAResults}{A list of data frames obtained from runPathwayAnalysis.}

\item{method}{A method used to combine pathway analysis results}
}
\value{
A dataframe of meta analysis results including combined normalized score and combined p-value for each pathway.
}
\description{
This function performs meta analysis on multiple pathway analysis results.
}
\details{
This function performs mata analysis on multiple pathway analysis results.
}
\examples{
\donttest{

library(RCPA)
affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")

metaPAResult <- RCPA::runPathwayMetaAnalysis(
    list(affyFgseaResult, agilFgseaResult, RNASeqFgseaResult),
    method = "stouffer"
)
}
}
