% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{modify_label_pieces}
\alias{modify_label_pieces}
\title{Modify pieces of row and column labels}
\usage{
modify_label_pieces(
  labels,
  piece,
  mod_map,
  prepositions = RCLabels::prepositions,
  notation = RCLabels::bracket_notation
)
}
\arguments{
\item{labels}{The row and column labels in which pieces will be modified.}

\item{piece}{The piece (or pieces) of the row or column label that will be modified.}

\item{mod_map}{A modification map. See details.}

\item{prepositions}{A list of prepositions, used to detect prepositional phrases.
Default is \code{RCLabels::prepositions}.}

\item{notation}{The notation used in \code{labels}.
Default is \code{RCLabels::bracket_notation}.}
}
\value{
\code{labels} with replacements according to \code{piece} and \code{mod_map}.
}
\description{
This function modifies pieces of row and column labels
according to \code{label_map} that defines "one or many to one" relationships.
This function is useful for aggregations.
For example, replacing nouns can be done by
\verb{modify_label_pieces(<<labels>>, piece = "noun", label_map = list(new_noun = c("a", "b", "c"))}.
The string "new_noun" will replace any of "a", "b", or "c"
when they appear as nouns in a row or column label.
See examples for details.
}
\details{
Typical \code{piece}s include "noun" or a preposition,
such as "in" or "from".
See \code{RCLabels::prepositions} for additional examples.
This argument may be a single string or a character vector.

The \code{mod_map} argument should consist of a
named list of character vectors in which names indicate
strings to be inserted and values indicate
values that should be replaced.
The sense is \code{new = old} or \code{new = olds},
where "new" is the new name (the replacement) and
"old" and "olds" is/are a string/vector of strings,
any one of which will be replaced by "new".
}
\examples{
# Simple case
modify_label_pieces("a [of b in c]",
                    piece = "noun",
                    mod_map = list(new_noun = c("a", "b")))
# Works with a vector or list of labels
modify_label_pieces(c("a [of b in c]", "d [-> e in f]"),
                    piece = "noun",
                    mod_map = list(new_noun = c("d", "e")))
# Works with multiple items in the mod_map
modify_label_pieces(c("a [of b in c]", "d [-> e in f]"),
                    piece = "noun",
                    mod_map = list(new_noun1 = c("a", "b", "c"),
                                   new_noun2 = c("d", "e", "f")))
# Works with multiple pieces to be modified
modify_label_pieces(c("a [of b in c]", "d [-> e in f]"),
                    piece = c("noun", "in"),
                    mod_map = list(new_noun = c("a", "b", "c"),
                                   new_in   = c("c", "f")))
}
