% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbHasCompleted}
\alias{dbHasCompleted}
\alias{dbHasCompleted,AthenaResult-method}
\title{Completion status}
\usage{
\S4method{dbHasCompleted}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbHasCompleted()} returns a logical scalar. \code{TRUE} if the query has completed, \code{FALSE} otherwise.
}
\description{
This method returns if the query has completed.
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())

# Check if query has completed
res <- dbSendQuery(con, "show databases")
dbHasCompleted(res)

dbClearResult(res)

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbHasCompleted}}
}
