% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI.R
\name{aqs_sites_by_county}
\alias{aqs_sites_by_county}
\title{aqs_sites_by_county}
\usage{
aqs_sites_by_county(stateFIPS, countycode, return_header = FALSE)
}
\arguments{
\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{countycode}{a R character object which represents the 3 digit state
FIPS code for the county being requested (with leading
zero(s)). @seealso \code{\link[=aqs_counties_by_state]{aqs_counties_by_state()}} for the
list of available county codes for each state.}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of all air monitoring
sites with the requested state and county FIPS codes.
}
\description{
\lifecycle{stable}
Returns data containing a table of all air monitoring sites
with the input state and county FIPS code combination.
}
\examples{
#returns an AQS_Data Mart_APIv2 S3 object witch returns all sites
          #  in Hawaii County, HI
          \dontrun{aqs_sites_by_county(stateFIPS = "15",
                                           countycode = "001")
                 }
}
