% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/runMLwiN.R
\name{runMLwiN}
\alias{runMLwiN}
\title{Calls MLwiN from R.}
\usage{
runMLwiN(Formula, levID = NULL, D = "Normal", data = NULL,
  estoptions = list(EstM = 0), BUGO = NULL, MLwiNPath = NULL,
  stdout = "", stderr = "", workdir = tempdir(), checkversion = TRUE,
  indata = NULL)
}
\arguments{
\item{Formula}{A \code{\link[stats]{formula}} object specifying the model
formula. See \code{\link{Formula.translate}} (\code{\link{Formula.translate.compat}}
details back-compatible functionality for deprecated syntax used in
versions of \pkg{R2MLwiN} prior to 0.8-0).}

\item{levID}{A character vector specifying the level ID(s). Deprecated
syntax: by default this is \code{NULL} and level ID(s) are specified
in the \code{Formula} object.}

\item{D}{A character string/vector specifying the type of distribution to be modelled, which
can include \code{'Normal'} (the default), \code{'Binomial'}, \code{'Poisson'},
\code{'Negbinom'}, \code{'Unordered Multinomial'}, \code{'Ordered Multinomial'},
\code{'Multivariate Normal'}, or \code{'Mixed'}. In the case of the latter,
\code{'Mixed'} precedes the response types which also need to be listed in
\code{D}, e.g. \code{c('Mixed', 'Normal', 'Binomial')}; these need to be
be listed in the same order to which they are referred to in the
\code{Formula} object (see \code{\link{Formula.translate}},
\code{\link{Formula.translate.compat}}). For (R)IGLS estimation (i.e. \code{EstM = 0}
in \code{estoptions}) \code{'Mixed'} combinations can consist of
\code{'Normal'} and \code{'Binomial'} or \code{'Normal'} and \code{'Poisson'};
for MCMC estimation (i.e. \code{EstM = 0}), on the other hand, only a combination
of \code{'Normal'} and \code{'Binomial'} is available.}

\item{data}{A data.frame object containing the data to be modelled.
Optional (but recommended): if empty, data taken from environment of
\code{formula}.}

\item{estoptions}{A list of options used for estimating the model. See
`Details' below.}

\item{BUGO}{A vector specifying BUGS options. If non-null, then
WinBUGS/OpenBUGS, in conjunction with MLwiN, are used for modelling. Non-null
only applicable if \code{EstM = 1}. See `Details', below.}

\item{MLwiNPath}{A path to the MLwiN folder. By default, \code{MLwiNPath = NULL}
and path set by \code{options('MLwiN_path')}, the default for which can be
changed via \code{options(MLwiN_path = 'path/to/MLwiN vX.XX/')}).}

\item{stdout}{See \code{\link[base]{system2}}; \code{''} by default (i.e.
output to \code{stdout} sent to R console).}

\item{stderr}{See \code{\link[base]{system2}}; \code{''} by default (i.e.
output to \code{stderr} sent to R console).}

\item{workdir}{A path to the folder where the outputted files are to be saved.
If the folder specified does not exist, a new folder of that name is
created; \code{workdir = tempdir()} by default.}

\item{checkversion}{If \code{TRUE} (default), returns version number unless
(a) version detected is unknown or newer than MLwiN version available
when current version of R2MLwiN was released, in which case returns text
to this effect, or (b) version detected > 1 year older than MLwiN version
available when current version of R2MLwiN was released, in which case
function call stopped and user invited to update via usual channels. Can
disable via \code{FALSE} e.g. if slowing execution time down (for example
in a simulation).}

\item{indata}{A \code{data.frame} object containing the data to be modelled.
Deprecated syntax: by default this is \code{NULL} and the \code{data.frame}
is instead referenced via \code{data}.}
}
\value{
If \code{BUGO} is non-NULL then the output is an \code{\link{mcmc.list}}
object.

If the IGLS algorithm is used (i.e., \code{EstM = 0}), then returns \code{\link{mlwinfitIGLS-class}} object;
if MCMC estimation used (i.e., \code{EstM = 1}), then returns \code{\link{mlwinfitMCMC-class}} object.
}
\description{
This function executes MLwiN and then brings results back to R.
}
\details{
With regard to \code{runMLwiN}'s \code{Formula} object, see \code{\link[stats]{formula}}
for notes on general usage, noting the following differences:

\itemize{
\item{The intercept is not included by default (this is keeping with the manner
in which models are specified in MLwiN). To include an intercept, then, one
can specify e.g. \code{normexam ~ 1 + standlrt + (1 | student)} or, assuming \code{cons}
is a constant of ones, \code{normexam ~ cons + standlrt + (cons | student)}. (Note also,
as further detailed below, for normal response models the level 1 ID (\code{student} in this example)
needs to be explicitly included in the random part of the model formula; this is not the
case for discrete response models.}
\item{The link function and denominator are included in the \code{Formula} object, e.g.
fitting a logistic model in which the variable \code{denom} is specified as the denominator:
\code{logit(resp, denom) ~ 1 + age + (1 | region)}.}
}

Further details are as follows.

The random part of the model is specified in sets of parentheses arranged in
descending order with respect to their hierarchy. E.g. in the case of a 3-level
model, the variable containing the level 3 ID is specified first, then
the variable containing the level 2 ID, etc. Note that the variable containing
the level 1 ID also needs to be explicitly specified unless
it is a discrete response model (in which case you should not specify it).

The table below summarises the options for the \code{Formula} argument in
\pkg{R2MLwiN}. They assume an intercept is added (via \code{~ 1}; for alternative
specifications see \code{\link[stats]{formula}}). \code{<link>} denotes the link function,
\code{<y1>}, \code{<y2>}, etc. represent response variables, \code{<denom>} denotes
the denominator, \code{<offs>} the offset (optional), \code{<L2>}, \code{<L1>}, etc. the
variables containing the level 2 and level 1 identifying codes, and \code{<ref_cat>}
represents the reference category of a categorical response variable (optional:
if unspecified the lowest level of the factor is used as the reference category).
Explanatory variables are specified as e.g. \code{<x1> + <x2>}. For \code{'Ordered Multinomial'},
\code{'Multivariate Normal'} and \code{'Mixed'} responses, \code{[<common>]} indicates
a common coefficient (i.e. the same for each category) is to be fitted; here \code{<common>}
takes the form of a numeric identifier indicating the responses for which a common
coefficient is to be added (e.g. \code{[1:5]} to fit a common coefficient for
categories \code{1} to \code{5} of a 6-point ordered variable, \code{[1]} to fit a common
coefficient for the response variable specified first in the \code{Formula} object
for a \code{'Mixed'} response model, etc.) Otherwise a separate coefficient
(i.e. one for each category) is added. For \code{'Mixed'} response models, the
\code{Formula} arguments need to be grouped in the order the distributions
are listed in \code{D}.

* denotes IGLS only in the table below.

\tabular{lll}{
\strong{Distribution} \tab \strong{Format of \code{Formula} object} \tab \strong{Where \code{<link>} can equal...}\cr
\code{'Normal'} \tab \code{<y1> ~ 1 + <x1> + (<L2>|1) + (<L1>|1) + ...} \tab (identity link assumed)\cr
\code{'Poisson'} \tab \code{<link>(<y1>) ~ 1 + offset(<offs>) + <x1> + (<L2>|1) + ...} \tab \code{log}\cr
\code{'Negbinom'}* \tab \code{<link>(<y1>) ~ 1 + offset(<offs>) + (<L2>|1) + ...} \tab \code{log}\cr
\code{'Binomial'} \tab \code{<link>(<y1>, <denom>) ~ 1 + <x1> + (<L2>|1) + ...} \tab \code{logit},\code{probit},\code{cloglog}\cr
\code{'Unordered Multinomial'} \tab \code{<link>(<y1>, <denom>, <ref_cat>) ~ 1 + <x1> + (<L2>|1) + ...} \tab \code{logit}\cr
\code{'Ordered Multinomial'} \tab \code{<link>(<y1>, <denom>, <ref_cat>) ~ 1 + <x1> + <x2>[<common>] + (<L3>|1[<common>]) + (<L2>|1) + ...} \tab \code{logit},\code{probit},\code{cloglog}\cr
\code{'Multivariate Normal'} \tab \code{c(<y1>, <y2>, ...) ~ 1 + <x1> + <x2>[<common>] + (<L3>|1[<common>]) + (<L2>|1) + (<L1>|1) + ...} \tab (identity link assumed)\cr
\code{c('Mixed', 'Normal', 'Binomial')} \tab \code{c(<y1>, ..., <link> (<y2>, <denom>), ...) ~ 1 + <x1> + <x2>[<common>] + (<L3>|1[<common>]) + (<L2>|1) + (<L1>|1) + ...} \tab \code{logit}*,\code{probit},\code{cloglog}*\cr
\code{c('Mixed', 'Normal', 'Poisson')}* \tab \code{c(<y1>, ..., <link>(<y2>, <offset>), ...) ~ 1 + <x1> + <x2>[<common>] + (<L3>|1[<common>]) + (<L2>|1) + (<L1>|1) + ...} \tab \code{log}\cr
}

The argument \code{estoptions} is a list which can contain the
following options used for estimating the model:

\itemize{
\item \code{EstM}: specifies estimation method. When \code{EstM = 0} (default), estimation
method is (R)IGLS, otherwise \code{EstM = 1} specifies MCMC estimation.

\item \code{resi.store}: a logical value indicating whether residuals are to be
stored or not. Defaults to \code{FALSE}.

\item \code{resioptions}: a string vector to specify the various residual options.
The \code{'variance'} option calculates the posterior variances instead of
the posterior standard errors; the \code{'standardised'}, \code{'leverage'}, \code{'influence'}
and \code{'deletion'} options calculate standardised,
leverage, influence and deletion residuals respectively; the
\code{'sampling'} option calculates the sampling variance covariance matrix
for the residuals; the \code{'norecode'} option prevents residuals with values exceedingly close or
equal to zero from being recoded to missing.
When \code{EstM = 1} (i.e. MCMC estimation) \code{'variance'}
is default value, and the only other permissible value is \code{'standardised'}
(else function call stopped with appropriate error message).
When \code{EstM = 0} (i.e. (R)IGLS estimation), \code{'variance'}
cannot be specified together with \code{'standardised'}, \code{'leverage'} or
\code{'deletion'} (function call stopped with appropriate error message).
Default is \code{resioptions = c('variance')}.

\item \code{resi.store.levs}: an integer vector indicating the levels at which the
residual chains are to be stored (\code{NULL} by default). Non-\code{NULL} values
not valid when \code{EstM = 0} (i.e. (R)IGLS estimation), else if \code{EstM = 0}
and \code{resi.store.levs} non-\code{NULL}, residual chains at specified levels
are returned.

\item \code{debugmode}: a logical value determining whether MLwiN is run in the
background or not. The default value is \code{FALSE}: i.e. MLwiN is run in
the background. If \code{TRUE} the MLwiN GUI is opened, and then pauses after the model
has been set-up, allowing user to check starting values; pressing 'Resume macro'
will then fit the model. Once fit, pressing 'Resume macro' once more will save
the outputs to the \code{workdir} ready to be read by \pkg{R2MLwiN}. Users can
instead opt to 'Abort macro' in which case the outputs are not saved to the
\code{workdir}. This option currently
works for 32 bit version of MLwiN only (automatically switches unless
\code{MLwiNPath} or \code{options(MLwiNPath)}
has been set directly to the executable).

\item \code{x64}: a logical value indicating
whether the 64 bit version of MLwiN is used (unless \code{MLwiNPath} or \code{options(MLwiNPath)}
has been set directly to the executable). The default is determined by the characteristics
of the operating system on which the script is executed. If \code{FALSE},
the 32 bit version is called, if \code{TRUE} 64 bit version is called.

\item \code{clean.files}: specifies whether the generated files are removed from
the \code{workdir} (\code{TRUE}, the default) or not (\code{FALSE}).

\item \code{show.file}: a logical value indicating whether the output files (e.g.
MLwiN macro file) are shown on the screen. Defaults to \code{FALSE}.

\item \code{clre}: a matrix used to define which elements of the random effects matrix
to remove (i.e. hold constant at zero). Removes
from the random part at level <first row> the covariance matrix element(s)
defined by the pair(s) of rows <second row> <third row>. Each column
corresponds to a removed entry of the covariance matrix. See e.g. \code{demo(UserGuide07)}
for an example.

\item \code{notation}: specifies the model subscript notation
to be used in the MLwiN equations window. \code{'class'} means no multiple
subscripts, whereas \code{'level'} has multiple subscripts. If
\code{notation = NULL}, defaults to \code{'level'} if \code{'xc = NULL'} else
defaults to \code{'class'}.

\item \code{mem.init}: sets and displays worksheet capacities for
the current MLwiN session. A vector of length 5 corresponding to
the following order: number of levels (defaults to 1 + the number of
levels specified in the function call); worksheet size in thousands of cells
(default is 6000); the number of columns (default is 2500); the number of
explanatory variables (default it 10 + number of explanatory variables
calculated initially); the number of group labels (default is 20).

\item \code{optimat}: instructs MLwiN to limit the maximum matrix size
that can be allocated by the (R)IGLS algorithm. Specify \code{optimat = TRUE}
if MLwiN gives the following error message 'Overflow allocating smatrix'.
This error message arises if one or more higher-level units is/are extremely
large (containing more than 800 lower-level units). In this situation \code{runMLwiN}'s
default behaviour is to instruct MLwiN to allocate a larger matrix size to
the (R)IGLS algorithm than is currently possible. Specifying
\code{optimat = TRUE} caps the maximum matrix size at 800 lower-level units,
circumventing the MLwiN error message, and allowing most MLwiN
functionality.

\item \code{nonlinear}: a character vector specifying linearisation method for discrete
response models estimated via IGLS (see Chapter 9 of Rasbash et al 2012,
and Goldstein 2011). \code{N = 0} specifies marginal quasi-likelihood
linearization (MQL), whilst \code{N = 1} specifies penalised quasi-
likelihood linearization (PQL); \code{M = 1} specifies first order
approximation, whilst \code{M = 2} specifies second order approximation.
\code{nonlinear = c(N = 0, M = 1)} by default. First order marginal
quasi-likelihood (MQL1) only option for single-level discrete response
models. Pertains to discrete response models estimated via IGLS: i.e. when
\code{EstM = 0} in \code{estoptions}, and for starting values when estimated via IGLS
for MCMC (\code{EstM = 1}).

\item \code{Meth}: specifies which maximum likelihood estimation method is to be
used. If \code{Meth = 0} estimation method is set to RIGLS. If \code{Meth = 1}
estimation method is set to IGLS (the default setting).  Pertains to models
estimated via (R)IGLS: i.e. when \code{EstM = 0} in \code{estoptions}, and for starting
values when estimated via (R)IGLS for MCMC (\code{EstM = 1}).

\item \code{merr}: a vector which sets-up measurement errors on predictor
variables. The first element \code{N} defines the number of variables that
have measurement errors. Then, for each variable with measurement error, a
pair of inputs are required: the first of these is the explanatory variable
name as a character string, and the second is the variance of
the measurement error for this variable. See \code{demo(MCMCGuide14)} for an
example.

\item \code{fact}: a list of objects specified for factor analysis,
including:
\itemize{
\item \code{nfact}: Specifies the number of factors
\item \code{lev.fact}: Specifies the level/classification for the random part of
the factor for each factor.
\item \code{nfactcor}: Specifies the number of
correlated factors
\item \code{factcor}: A vector specifying the correlated
factors: the first element corresponds to the first factor number, the
second to the second factor number, the third element corresponds to the
starting value for the covariance and the fourth element to whether this
covariance is constrained
(\code{1}) or not (\code{0}). If more than one pair of factors is correlated,
then repeat this sequence for each pair.
\item \code{loading}: A matrix specifying the
starting values for the factor loadings and the starting value of the factor
variance. Each row corresponds to a factor.
\item \code{constr}: A matrix
specifying indicators of whether the factor loadings and the factor variance
are constrained (\code{1}) or not (\code{0}).
}

\item \code{weighting}: a deprecated option for specifying weights in IGLS estimation:
see \code{fpsandwich} and \code{rpsandwich} for new method of doing so.
\code{weighting} is a list of objects including \code{levels}, \code{weights},
\code{mode}, \code{FSDE} and \code{RSDE}; see \code{\link{write.IGLS}} for details.

\item \code{centring}: deprecated method (only applicable when using old syntax
pre-\pkg{R2MLwiN} v.0.8-0) specifying function by
which explanatory variables are to be centred (users can instead transform
variables prior to \code{runMLwiN} call).
If non-\code{NULL}, centring is used for the selected explanatory
variables (\code{centring = NULL} by default). \code{centring} is a list of
objects specifying the methods to be used to centre specific explanatory
variables. E.g. \code{list(age = 1, ...)} specifies that the explanatory
variable \code{age} is to be centred around its grand mean;
\code{list(age = c(2, 'district'), ...)} specifies that \code{age} is to be
centred around its group mean, where group defined by the variable \code{district};
and \code{list(age = c(3, 18), ...)} specifies that \code{age} is to
be centred around the value \code{18}.

\item \code{xclass}: a deprecated option for specifying cross-classified and/or
multiple membership models; see \code{xc} and \code{mm} for new method of
doing so. \code{xclass} is a list of objects including \code{class},
\code{N1}, \code{weight}, \code{id} and \code{car}; see \code{\link{write.MCMC}} for details.

\item \code{mcmcOptions}: a list of objects specifying MCMC options, including the
following:
\itemize{
\item \code{orth}: If \code{orth = 1}, orthogonal fixed effect
vectors are used; zero otherwise.
\item \code{hcen}: An integer specifying the
level where we use hierarchical centering.
\item \code{smcm}: If \code{smcm = 1},
structured MCMC is used; zero otherwise.
\item \code{smvn}: If \code{smvn = 1}, the
structured MVN framework is used; zero otherwise.
\item \code{paex}: A matrix of Nx2; in each row, if the second digit is \code{1}, parameter expansion
is used at level <the first digit>.
\item \code{mcco}: This
command allows the user to have constrained settings for the lowest level
variance matrix in a multivariate Normal model. If value is \code{0},
it estimates distinct variances for each residual error and distinct covariances
for each residual error pair. Four other
settings are currently available:\cr
\tabular{ll}{\code{1} \tab fits stuctured errors with a common correlation paramater and a common variance parameter;\cr
\code{2} \tab fits AR1 errors with a common variance parameter;\cr \code{3} \tab fits structured errors with a common
correlation parameter and independent variance parameters;\cr \code{4} \tab fits AR1 errors with independent variance
parameters.\cr }
}

\item \code{drop.data}: If \code{TRUE} (default) only the data involved in the model
is passed to MLwiN, otherwise the entire dataset in \code{data} is passed.

\item \code{fpsandwich}: specifies standard error type for fixed parameters. If
\code{fpsandwich = TRUE}, robust or `sandwich' standard errors based on raw
residuals are used, if \code{fpsandwich = FALSE} (default) then standard,
uncorrected, IGLS or RIGLS computation used.

\item \code{rpsandwich}: specifies standard error type for random parameters. If
\code{rpsandwich = TRUE}, robust or `sandwich' standard errors based on raw
residuals are used, if \code{rpsandwich = FALSE} (default) then standard,
uncorrected, IGLS or RIGLS `plug in' estimates used.

\item \code{smat}: a matrix with two columns the levels at which a diagonal
matrix is to be specified. The first column specifies the level.
If the value of the second column is \code{1} then the random covariance matrix is
set to be diagonal.

\item \code{maxiter}: a numeric value specifying the maximum number of iterations, from
the start, before (R)IGLS estimation halts. Pertains to models
estimated via (R)IGLS: i.e. when \code{EstM = 0} in \code{estoptions}, and for starting
values when estimated via (R)IGLS for MCMC (\code{EstM = 1}).

\item \code{tol}: a numeric value specifying the convergence criterion.
If value is m, estimation will be
deemed to have converged when the relative change in the estimate for all
parameters from one iteration to the next is less than 10(-m). Defaults to
value of \code{2} for m if not otherwise specified.  Pertains to models
estimated via (R)IGLS: i.e. when \code{EstM = 0} in \code{estoptions}, and for starting
values when estimated via (R)IGLS for MCMC (\code{EstM = 1}).

\item \code{extra}: if \code{TRUE}, extra binomial, extra negative binomial,
extra Poisson or extra multinomial distributions assumed, else \code{FALSE}.
can only be specified for discrete response models (i.e. \code{'Binomial'},
\code{'Negbinom'}, \code{'Poisson'}, \code{'Multinomial'})
estimated via (R)IGLS (i.e. \code{EstM = 0}).

\item \code{reset}: a vector specifying the action to be
taken, at each level, if a variance parameter is estimated at a particular
iteration to be negative during estimation. Values specified in
ascending order of level hierarchy: if \code{0} a negative variance
estimate is reset to zero and so are any associated covariances; if \code{1}
a negative variance estimate is reset to zero but not the associated
covariances; if \code{2} no resetting takes place. E.g. \code{reset = c(0, 1)}
to assign value \code{0} to level 1 and value \code{1} to level 2 of
two-level model.

\item \code{constraints}: \code{fixed.ui} and \code{fixed.ci} specify constraint
on the fixed coefficients, \code{random.ui} and \code{random.ci} specify
constraints on the random parameters. Applies to \code{EstM = 0} (i.e. estimation
via (R)IGLS) only.

\item \code{xc}: indicates whether model is cross-classified (\code{TRUE}) or
nested (\code{FALSE}). Ignored if \code{EstM = 0}, i.e. only applicable to
models estimated via MCMC. Defaults to \code{xc = FALSE}, unless either
\code{mm} or \code{car} are non-\code{NULL}, in which case \code{xc = TRUE}. Supersedes
deprecated \code{xclass}.

\item \code{mm}: specifies the structure of a multiple membership model.
Can be a list of variable names, a list of vectors, or a matrix (e.g. see
\code{\link{df2matrix}}). In the case of the former, each
element of the list corresponds to a level (classification) of the model,
in descending order. If a level is not a multiple membership classification,
then \code{NA} is specified. Otherwise, lists need to be assigned to
\code{mmvar} and \code{weights}, with the former containing columns
specifying the classification units, and the latter containing columns
specifying the weights. Ignored if \code{EstM = 0}, i.e. only applicable to models estimated via
MCMC. \code{mm = NULL} by default. Supersedes deprecated \code{xclass}.
E.g. (from \code{demo(MCMCGuide16)}) for
\code{logearn ~ 1 + age_40 + sex + parttime + (1 | company) + (1 | id)}, if
\code{company} is a multiple membership classification with the variables
indicating the classifications in \code{company}, \code{company2},
\code{company3}, \code{company4} and their weights in \code{weight1}, \code{weight2},
\code{weight3} and \code{weight4} then
\code{mm = list(list(mmvar = list('company', 'company2', 'company3', 'company4'),}
\code{weights = list('weight1', 'weight2', 'weight3', 'weight4')), NA)}
with the \code{NA}, listed last, corresponding to the level 1 identifier (\code{id}).

\item \code{car}: specifies the structure of a conditional autoregressive (CAR)
model. Can be a list of variable names, a list of vectors, or a matrix (e.g. see
\code{\link{df2matrix}}). In the case of the former, each element of the list
corresponds to a level (classification) of
the model, in descending order. If a level is not a spatial classification,
then \code{NA} is specified. Otherwise, lists need to be assigned to
\code{carvar} and \code{weights}, with the former containing columns
specifying the spatial classification units, and the latter containing
columns specifying the weights. See \code{demo(MCMCGuide17)} for examples.
Ignored if \code{EstM = 0}, i.e. only applicable
to models estimated via MCMC. \code{car = NULL} by default. Supersedes
deprecated \code{xclass}. See \code{demo(MCMCGuide17)} for examples.

\item \code{carcentre}: if CAR model (i.e. if \code{car} is non-\code{NULL}),
\code{carcentre = TRUE} mean-centres all random effects at that level.
\item \code{startval}: a list of numeric vectors specifying the starting values.
\code{FP.b} corresponds to the estimates for the fixed
part; \code{FP.v} specifies the variance/covariance estimates for the fixed
part; \code{RP.b} specifies the variance estimates for the random part;
\code{RP.v} corresponds to the variance/covariance matrix of the variance
estimates for the random part. \code{startval = NULL} by default: i.e. when
\code{EstM = 0} the OLS estimates are used, else if \code{EstM = 1} the
estimates obtained from IGLS are used as the starting values for MCMC.

\item \code{sort.force}: If \code{TRUE} will sort data based on hierarchy as
determined by model formula; defaults to \code{FALSE}.

\item \code{sort.ignore}: If \code{FALSE} will check data is sorted in a manner in
keeping with the hierarchy implied by the model formula, and will return a warning
if that is not the case.

\item \code{mcmcMeth}: list of objects specifying MCMC methodology and prior
options, including the following (see \code{\link{write.MCMC}} for further details):
\itemize{
\item \code{iterations}: Number of main iterations post-burnin (i.e. monitoring chain length), defaults to 5000.
\item \code{burnin}: Length of burnin, defaults to 500.
\item \code{thinning}: Thinning factor, defaults to 1.
\item \code{seed}: MCMC random number seed, defaults to 1.
\item \code{priorParam}: A list specifying informative priors. This includes:
\code{fixe} -- for the fixed
parameters, if proper normal priors are used for some parameters, a list of
vectors of length two is provided, each of which specifies the mean and the
standard deviation. If not given, default ('flat' or 'diffuse') priors are
used for the parameters; \code{fixe.common} -- for multivariate normal,
multinomial and mixed response models, if common coefficients are added, use
\code{fixe.common} rather than \code{fixe}; \code{fixe.sep} -- if the common
coefficients are added, use \code{fixe.sep} for the separate coefficients;
\code{rp1} -- a list object specifying the Wishart or gamma prior for the
covariance matrix or scalar variance at level 1 (this consists of: (1)
\code{estimate} -- an estimate for the true value of the inverse of the
covariance matrix; (2) \code{size} -- the number of rows in the covariance
matrix. Note that this is a weakly-informative prior and the default prior
is used if missing); \code{rp2} -- a list object specifying the Wishart or
gamma prior for the covariance matrix or scalar variance at level 2 (this
consists of: (1) \code{estimate} -- an estimate for the true value of the
inverse of the covariance matrix; (2) \code{size} -- the number of rows in
the covariance matrix. Note that this is a weakly-informative prior and the
default prior is used if missing).
\item \code{scale}: Scale factor for proposal variances: this number will be
multiplied by the estimated parameter variance (from IGLS/RIGLS) to give the
proposal distribution variance. Defaults to 5.8.
\item \code{refresh}: Number of iterations after which screen (in MLwiN GUI) is
to be refreshed. Defaults to 50.
\item \code{fixM}: Specifies the estimation method for the fixed effects:
\code{1} for Gibbs sampling, \code{2} for univariate Metropolis-Hastings (MH)
sampling and \code{3} for multivariate MH sampling. Defaults to \code{2} if
Poisson, Multinomial, Binomial or Mixed model, else defaults to \code{1}.
\item \code{residM}: Specifies the estimation method for the random effects
(residuals): \code{1} for Gibbs sampling, \code{2} for univariate
Metropolis-Hastings (MH) sampling and \code{3} for multivariate MH sampling.
Defaults to \code{2} if Poisson, Multinomial, Binomial or Mixed model,
else defaults to \code{1}.
\item \code{Lev1VarM}: Specifies the estimation method for the level 1 variance:
\code{1} for Gibbs sampling, \code{2} for univariate
Metropolis-Hastings (MH) sampling and \code{3} for multivariate MH sampling.
Defaults to \code{2} if Poisson, Multinomial, Binomial or Mixed model,
else defaults to \code{1}.
\item \code{OtherVarM}: Specifies the estimation method for the higher level
variance matrices: \code{1} for Gibbs sampling, \code{2} for univariate
Metropolis-Hastings (MH) sampling and \code{3} for multivariate MH sampling.
Defaults to \code{1}.
\item \code{adaption}: \code{adaption = 1} (the default) indicates adaptation is to be used,
\code{adaption = 0} indicates it is not.
\item \code{tol}: An integer specifying tolerance (as a percentage; defaults to 10) when
\code{adaption = 1} (ignored if \code{adaption = 0}).
\item \code{rate}: An integer specifying the acceptance rate (as a percentage; defaults
to 50) when \code{adaption = 1} (ignored if \code{adaption = 0}).
\item \code{priorcode}: An integer indicating which default priors are to be used
for the variance parameters. This parameter takes the value \code{1} (the default) for
Gamma priors or \code{0} for Uniform on the variance scale priors. See the
section on 'Priors' in the MLwiN help system for more details on the meaning
of these priors.
\item \code{startval}: Deprecated: starting values are now specified directly
within \code{estoptions}.
\item \code{lclo}: Toggles on/off the possible forms of complex level
1 variation when using MCMC. By default (\code{lclo = 0}) the level
1 variation is expressed as a function of the predictors. Else
(\code{lclo = 1}) the log of the level 1 precision (1/variance) is expressed as
a function of the predictors. Defaults to \code{lclo = 0}.
\item \code{dami}: Outputs a complete (i.e. including non-missing
responses) response variable y. If \code{dami = c(0, <iter1>, <iter2>, ...)} then
the response variables returned will be the value of y at the iterations
quoted (as integers \code{<iter1>, <iter2>}, etc.); these can be used for
multiple imputation. If \code{dami = 1} the value of y will be the mean
estimate from the iterations produced. \code{dami = 2} is as for \code{dami = 1}
but with the standard errors of the estimate additionally being stored.
\code{dami = NULL} by default.
}
}
The argument \code{BUGO} is a vector specifying BUGS options as follows:
\itemize{
\item \code{n.chains}: specifies the
number of chains used by BUGS.
\item \code{debug}: determines
whether BUGS stays open following completion of the model run;
\code{debug = FALSE} by default.
\item \code{seed}: sets the random number
generator in BUGS.
\item \code{bugs}: specifies the path of the BUGS
executable.
\item \code{OpenBugs}: if \code{OpenBugs = TRUE}, OpenBUGS is used.
Otherwise (i.e. \code{OpenBugs = FALSE}, the default) WinBUGS is used.
}
}
\examples{
## The R2MLwiN package includes scripts to replicate all the analyses in
## Rasbash et al (2012) A User's Guide to MLwiN Version 2.26 and
## Browne, W.J. (2012) MCMC estimation in MLwiN Version 2.26.
## The MLwiN manuals are available online, see:
## http://www.bristol.ac.uk/cmm/software/mlwin/download/manuals.html

\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## For a list of demo titles
demo(package = 'R2MLwiN')

## Take MCMCGuide03 as an example
## To view file
file.show(system.file('demo', 'MCMCGuide03.R', package='R2MLwiN'))

## To run the demo
demo(MCMCGuide03)
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\references{
Goldstein, H. (2011) Multilevel Statistical Models. 4th Edition. London: John Wiley and Sons.

Rasbash, J., Steele, F., Browne, W.J. and Goldstein, H. (2012)
A User's Guide to MLwiN Version 2.26. Centre for Multilevel Modelling,
University of Bristol.
}
\seealso{
\code{\link[stats]{formula}}, \code{\link{Formula.translate}}, \code{\link{Formula.translate.compat}}, \code{\link{write.IGLS}}, \code{\link{write.MCMC}}
}

