% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{import_corpus}
\alias{import_corpus}
\title{import_corpus}
\usage{
import_corpus(paths, format, language, textcolumn = 1, encoding = NULL)
}
\arguments{
\item{paths}{Path to one of more files, or to a directory (if \code{format="txt"}) to import.}

\item{format}{File format: can be \code{"csv"}, \code{"txt"}, \code{"factiva"}, \code{"europresse"},
\code{"lexisnexis"} or \code{"alceste"}.}

\item{language}{The language name or code (preferably as IETF language tags,
see \code{\link[NLP:language]{language}}) to be used in particular for stopwords and stemming.}

\item{textcolumn}{When \code{format="csv"}, the column containing the text, either
as a string or as a position}

\item{encoding}{The character encoding of the file, or \code{NULL} to attempt automatic detection.}
}
\value{
A \code{Corpus} object.
}
\description{
Import a corpus from a file.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
import_corpus(file, "factiva", language="en")

}
