% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JSContext.R
\name{JSContext}
\alias{JSContext}
\title{JSContext object}
\value{
A JSContext object containing an initialised JavaScript
context for evaluating scripts/commands
}
\description{
An initialised context within which to evaluate Javascript
scripts or commands.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-JSContext-new}{\code{JSContext$new()}}
\item \href{#method-JSContext-validate}{\code{JSContext$validate()}}
\item \href{#method-JSContext-source}{\code{JSContext$source()}}
\item \href{#method-JSContext-call}{\code{JSContext$call()}}
\item \href{#method-JSContext-clone}{\code{JSContext$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSContext-new"></a>}}
\if{latex}{\out{\hypertarget{method-JSContext-new}{}}}
\subsection{Method \code{new()}}{
Creates a new JSContext instance and initialises the QuickJS runtime and
evaluation context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSContext$new(stack_size = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stack_size}}{An optional fixed value for the stack size (in bytes)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, used internally to initialise the JSContext object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSContext-validate"></a>}}
\if{latex}{\out{\hypertarget{method-JSContext-validate}{}}}
\subsection{Method \code{validate()}}{
Checks whether a specified function or object is present in the initialised
context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSContext$validate(function_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{function_name}}{The name of the function to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean indicating whether the function is present
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSContext-source"></a>}}
\if{latex}{\out{\hypertarget{method-JSContext-source}{}}}
\subsection{Method \code{source()}}{
Evaluate a provided JavaScript file or string within the initialised context.
Note that this method should only be used for initialising functions or values
within the context, no values are returned from this function. See the \verb{$call()}
method for returning values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSContext$source(file = NULL, code = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{A path to the JavaScript file to load}

\item{\code{code}}{A single string of JavaScript to evaluate}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSContext-call"></a>}}
\if{latex}{\out{\hypertarget{method-JSContext-call}{}}}
\subsection{Method \code{call()}}{
Call a specified function in the JavaScript context with the
provided arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSContext$call(function_name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{function_name}}{The function to be called}

\item{\code{...}}{The arguments to be passed to the function}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The result of calling the specified function,
the return type is mapped from JS to R using \code{jsonlite::fromJSON()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSContext-clone"></a>}}
\if{latex}{\out{\hypertarget{method-JSContext-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSContext$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
