% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0Int_base_stats.R
\name{crossprod_inv}
\alias{crossprod_inv}
\title{Inverse of \eqn{X'X} by \eqn{QR} Decomposition}
\usage{
crossprod_inv(X)
}
\arguments{
\item{X}{\eqn{m*n} \link[base]{matrix}}
}
\value{
\link{crossprod_inv} returns the inverse \link[base]{matrix} of cross product \eqn{X'X}.
}
\description{
Compute \eqn{(X'X)^{-1}} from the \eqn{R} part of the \eqn{QR} decomposition of \eqn{X}.
}
\examples{
set.seed(123); (X = array(rnorm(40L), dim = c(8L, 5L)))
stopifnot(all.equal.numeric(solve(crossprod(X)), crossprod_inv(X)))


}
\references{
\url{https://en.wikipedia.org/wiki/QR_decomposition}, section \strong{Rectangular matrix}
}
\seealso{
\link[base]{chol2inv} \link[base]{chol.default}
}
