% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterQp.R
\name{clusterQp}
\alias{clusterQp}
\title{Cluster-Specific Sample Quantiles}
\usage{
clusterQp(
  data,
  contX = "Marker",
  include = names(data),
  exclude = NULL,
  from = 0.01,
  to = 0.99,
  by = 0.01,
  type = 7,
  ...
)
}
\arguments{
\item{data}{\link[base]{data.frame}}

\item{contX}{\link[base]{character} scalar,
column name of the variable, for which the quantiles will be calculated}

\item{include}{(optional) \link[base]{character} \link[base]{vector},
names of columns in \code{data} to be \link[stats]{aggregate}d by.
Default values are all columns in \code{data} (except for \code{contX})}

\item{exclude}{(optional) \link[base]{character} \link[base]{vector},
names of columns in \code{data} to be excluded from aggregation.
Default value is \code{NULL}}

\item{from, to, by}{\link[base]{numeric} scalars,
the starting, end, and increment values
to specify a sequence (via \link[base]{seq.int}) of probabilities
\eqn{\bold{p} = (p_1,\cdots,p_N)'}
for the sample quantiles \eqn{\bold{q} = (q_1,\cdots,q_N)'}}

\item{type}{\link[base]{integer} scalar, type of quantile algorithm, see \link[stats]{quantile}}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{clusterQp} returns an aggregated \link[base]{data.frame},
with a \link[base]{matrix} of sample quantiles named \code{contX}.
The column names of the quantile \link[base]{matrix} are the probabilities \eqn{\bold{p}}.
}
\description{
Obtain vectors of sample quantiles in each cluster of observations
}
\details{
\link{clusterQp} calculates \eqn{N} sample quantiles
in each aggregated cluster of observations.
The aggregated clusters are specified by parameters \code{include} and/or \code{exclude} via \link[stats]{aggregate}.
Sample quantiles \eqn{\bold{q}}, for all aggregated clusters, are stored in a \link[base]{matrix} with \eqn{N} columns.
}
\examples{
# see ?`Qindex-package`

}
