% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sws.r
\name{qwdap.sws}
\alias{qwdap.sws}
\title{Mode Selection by Stepwise Regression}
\usage{
qwdap.sws(real, ctqw, index, select_method, plotting)
}
\arguments{
\item{real}{the real series observed.}

\item{ctqw}{the 'CTQW' object.}

\item{index}{the index of the data for mode selection.}

\item{select_method}{choose a stepwise method.}

\item{plotting}{whether to plot.}
}
\value{
a 'QWMS' object.
}
\description{
Mode selection by Stepwise Regression. The purpose of this function
is to select the part modes with similar characteristics to the observed time series
from the modes generated by the quantum walk. And it is based on the linear model.
}
\details{
The 'QWMS' object include the original time series and the modes generated by
quantum walks.
}
\examples{
data("traffic.qw")
data("trafficflow")
res.sws <- qwdap.sws(trafficflow,traffic.qw,1,"bidirection",TRUE)
}
