% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRTthre.R
\name{LRTthre}
\alias{LRTthre}
\title{LRT Threshold}
\usage{
LRTthre(
  marker,
  type = "RI",
  ng = 2,
  cM = TRUE,
  ns = 200,
  gv = 25,
  speed = 1,
  simu = 1000,
  d.eff = FALSE,
  alpha = 0.05,
  console = TRUE
)
}
\arguments{
\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension 'k' represents the number of markers in the
chromosomes. The first column labels the chromosomes where the markers
are located, and the second column labels the positions of markers (in
morgan (M) or centimorgan (cM)). It's important to note that chromosomes
and positions must be sorted in order.}

\item{type}{character. The population type of the dataset. Includes
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI"). The default value is "RI".}

\item{ng}{integer. The generation number of the population type. For
instance, in a BC1 population where type="BC", ng=1; in an AI F3
population where type="AI", ng=3.}

\item{cM}{logical. Specify the unit of marker position. If cM=TRUE, it
denotes centimorgan; if cM=FALSE, it denotes morgan.}

\item{ns}{integer. The number of individuals for generating the
individual trait values. Changes in this value do not significantly
affect the outcome of the LRT threshold value.}

\item{gv}{numeric. The genetic variance for generating the
individual trait values. Changes in this value do not significantly
affect the outcome of the LRT threshold value.}

\item{speed}{numeric. The walking speed of the QTL analysis (in cM).}

\item{simu}{integer. Determines the number of simulation samples that
will be used to compute the LRT threshold using the Gaussian process.}

\item{d.eff}{logical. Specifies whether the dominant effect will be
considered in the parameter estimation for AI or RI population.}

\item{alpha}{numeric. The type I error rate for the LRT threshold.}

\item{console}{logical. Determines whether the process of the algorithm
will be displayed in the R console or not.}
}
\value{
The LRT threshold for QTL interval mapping.
}
\description{
The LRT threshold for QTL interval mapping based on the
Gaussian stochastic process (Kao and Ho 2012).
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
LRTthre(marker, type = "RI", ng = 2, speed = 2, simu = 60)
}
\references{
KAO, C.-H. and H.-A. Ho 2012 A score-statistic approach for determining
threshold values in QTL mapping. Frontiers in Bioscience. E4, 2670-2682. <doi: 10.2741/e582>
}
\seealso{
\code{\link[mvtnorm]{rmvnorm}}
}
