% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.MIM.R
\name{EM.MIM}
\alias{EM.MIM}
\title{EM Algorithm for QTL MIM}
\usage{
EM.MIM(
  D.matrix,
  cp.matrix,
  y,
  E.vector0 = NULL,
  X = NULL,
  beta0 = NULL,
  variance0 = NULL,
  conv = 10^-5,
  console = TRUE
)
}
\arguments{
\item{D.matrix}{matrix. The design matrix of QTL effects which is a
g*p matrix, where g is the number of possible QTL genotypes, and p
is the number of effects considered in the MIM model. The design
matrix can be easily generated by the function D.make().}

\item{cp.matrix}{matrix. The conditional probability matrix which
is an n*g matrix, where n is the number of individuals, and g is
the number of possible genotypes of QTLs. The conditional
probability matrix can be easily generated by the function Q.make().}

\item{y}{vector. An vector with n elements that contains the phenotype
values of individuals.}

\item{E.vector0}{vevtor. The initial value for QTL effects. The
number of elements corresponds to the column dimension of the
design matrix. If E.vector0=NULL, the initial value will be 0
for all effects.}

\item{X}{matrix. The design matrix of the fixed factors except
QTL effects. It is an n*k matrix, where n is the number of
individuals, and k is the number of fixed factors. If X=NULL,
the matrix will be an n*1 matrix that all elements are 1.}

\item{beta0}{vector. The initial value for effects of the fixed
factors. The number of elements corresponds the column dimension
of the fixed factor design matrix.  If beta0=NULL, the initial
value will be the average of y.}

\item{variance0}{numeric. The initial value for variance. If
variance0=NULL, the initial value will be the variance of
phenotype values.}

\item{conv}{numeric. The convergent criterion of EM algorithm.
The E and M steps will be iterated until a convergent criterion
is satisfied.}

\item{console}{logical. To decide whether the process of algorithm
will be shown in the R console or not.}
}
\value{
\item{E.vector}{The QTL effects calculated by EM algorithm.}
\item{beta}{The effects of the fixed factors calculated by EM
algorithm.}
\item{variance}{The variance calculated by EM algorithm.}
\item{PI.matrix}{The posterior probabilities matrix after the
process of EM algorithm.}
\item{LRT}{The LRT statistic of this model.}
\item{iteration.time}{The iteration time of EM algorithm.}
}
\description{
Expectation-maximization algorithm for QTL multiple interval mapping.
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
D.matrix <- D.make(3, type = "RI", aa = c(1, 3, 2, 3), dd = c(1, 2, 1, 3), ad = c(1, 2, 2, 3))
cp.matrix <- Q.make(QTL, marker, geno, type = "RI", ng = 2)$cp.matrix
result <- EM.MIM(D.matrix, cp.matrix, y)
result$E.vector
}
\references{
KAO, C.-H. and Z.-B. ZENG 1997 General formulas for obtaining the maximum
likelihood estimates and the asymptotic variance-covariance matrix in QTL
mapping when using the EM algorithm. Biometrics 53, 653-665.

KAO, C.-H., Z.-B. ZENG and R. D. TEASDALE 1999 Multiple interval mapping
for Quantitative Trait Loci. Genetics 152: 1203-1216.
}
\seealso{
\code{\link[QTLEMM]{D.make}}
\code{\link[QTLEMM]{Q.make}}
\code{\link[QTLEMM]{EM.MIM2}}
}
