% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRISK3-2017ver9.R
\name{QRISK3_2017}
\alias{QRISK3_2017}
\title{Cardiovascular Disease 10-year Risk Calculation (QRISK3 2017)}
\usage{
QRISK3_2017(
  data,
  patid,
  gender,
  age,
  atrial_fibrillation,
  atypical_antipsy,
  regular_steroid_tablets,
  erectile_disfunction,
  migraine,
  rheumatoid_arthritis,
  chronic_kidney_disease,
  severe_mental_illness,
  systemic_lupus_erythematosis,
  blood_pressure_treatment,
  diabetes1,
  diabetes2,
  weight,
  height,
  ethiniciy,
  heart_attack_relative,
  cholesterol_HDL_ratio,
  systolic_blood_pressure,
  std_systolic_blood_pressure,
  smoke,
  townsend
)
}
\arguments{
\item{data}{Specifiy your data.}

\item{patid}{Specifiy the patient identifier.}

\item{gender}{1: women 0: men.}

\item{age}{Specify the age of the patient in year (e.g. 64 years-old)}

\item{atrial_fibrillation}{Atrial fibrillation? (0: No, 1:Yes)}

\item{atypical_antipsy}{On atypical antipsychotic medication? (0: No, 1:Yes)}

\item{regular_steroid_tablets}{On regular steroid tablets? (0: No, 1:Yes)}

\item{erectile_disfunction}{A diagnosis of or treatment for erectile disfunction? (0: No, 1:Yes)}

\item{migraine}{Do patients have migraines? (0: No, 1:Yes)}

\item{rheumatoid_arthritis}{Rheumatoid arthritis? (0: No, 1:Yes)}

\item{chronic_kidney_disease}{Chronic kidney disease (stage 3, 4 or 5)? (0: No, 1:Yes)}

\item{severe_mental_illness}{Severe mental illness? (0: No, 1:Yes)}

\item{systemic_lupus_erythematosis}{Systemic lupus erythematosis (SLE)? (0: No, 1:Yes)}

\item{blood_pressure_treatment}{On blood pressure treatment? (0: No, 1:Yes)}

\item{diabetes1}{Diabetes status: type 1? (0: No, 1:Yes)}

\item{diabetes2}{Diabetes status: type 2? (0: No, 1:Yes)}

\item{weight}{Weight of patients (kg)}

\item{height}{Height of patients (cm)}

\item{ethiniciy}{Ethic group must be coded as the same as QRISK3 \cr

1 White or not stated \cr
2 Indian \cr
3 Pakistani \cr
4 Bangladeshi \cr
5 Other Asian \cr
6 Black Caribbean \cr
7 Black African \cr
8 Chinese \cr
9 Other ethnic group \cr}

\item{heart_attack_relative}{Angina or heart attack in a 1st degree relative < 60? (0: No, 1:Yes)}

\item{cholesterol_HDL_ratio}{Cholesterol/HDL ratio? (range from 1 to 11, e.g. 4)}

\item{systolic_blood_pressure}{Systolic blood pressure (mmHg, e.g. 180 mmHg)}

\item{std_systolic_blood_pressure}{Standard deviation of at least two most recent systolic blood pressure readings (mmHg)}

\item{smoke}{Smoke status must be coded as the same as QRISK3 \cr

    1 non-smoker \cr
    2 ex-smoker \cr
    3 light smoker (less than 10) \cr
    4 moderate smoker (10 to 19) \cr
    5 heavy smoker (20 or over) \cr}

\item{townsend}{Townsend deprivation scores}
}
\value{
Return a dataset with three columns: patient identifier, caculated QRISK3 score,  caculated QRISK3 score with only 1 digit
}
\description{
This function allows you to calculate 10-year individual CVD risk using QRISK3-2017.
}
\examples{
data(QRISK3_2019_test)
test_all <- QRISK3_2019_test

test_all_rst <- QRISK3_2017(data=test_all, patid="ID", gender="gender", age="age",
atrial_fibrillation="b_AF", atypical_antipsy="b_atypicalantipsy",
regular_steroid_tablets="b_corticosteroids", erectile_disfunction="b_impotence2",
migraine="b_migraine", rheumatoid_arthritis="b_ra", 
chronic_kidney_disease="b_renal", severe_mental_illness="b_semi",
systemic_lupus_erythematosis="b_sle",
blood_pressure_treatment="b_treatedhyp", diabetes1="b_type1",
diabetes2="b_type2", weight="weight", height="height",
ethiniciy="ethrisk", heart_attack_relative="fh_cvd", 
cholesterol_HDL_ratio="rati", systolic_blood_pressure="sbp",
std_systolic_blood_pressure="sbps5", smoke="smoke_cat", townsend="town")

test_all_rst$"QRISK_C_algorithm_score" <- test_all$"QRISK_C_algorithm_score"
test_all_rst$"diff" <- test_all_rst$"QRISK3_2017_1digit" - test_all_rst$"QRISK_C_algorithm_score"
print(test_all_rst$"diff")
print(identical(test_all_rst$"QRISK3_2017_1digit", test_all_rst$"QRISK_C_algorithm_score"))

}
\keyword{QRISK3_2017}
