% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_get_samples}
\alias{gigwa_get_samples}
\title{Get the Samples List of the Current Active GIGWA Project}
\usage{
gigwa_get_samples()
}
\value{
A vector of sample names in the selected project.
}
\description{
Retrieve the list of samples associated with the currently active GIGWA project,
set using `gigwa_set_project()`.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
  gigwa_set_project("Nelson_et_al_2011")
  samples <- gigwa_get_samples()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_project}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
