% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{gigwa_list_runs}
\alias{gigwa_list_runs}
\title{Get the list of run names in the selected GIGWA project}
\usage{
gigwa_list_runs()
}
\value{
a list of runs names
}
\description{
This function will retrieve the runs list from the current active project as configured 
in the internal configuration object using `gigwa_set_project()` function.
}
\examples{
if(interactive()) {
# config your GIGWA connection
set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                time_out = 300, engine = "gigwa", no_auth = TRUE)

# select a database by name
gigwa_set_db("Sorghum-JGI_v1")

# select a project by name
gigwa_set_project("Nelson_et_al_2011")

# list all runs in the selected project
gigwa_list_runs()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_project}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
