% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_study_info}
\alias{get_study_info}
\title{Get the details/metadata of the current active study}
\usage{
get_study_info()
}
\value{
a data frame of the study details/metadata
}
\description{
This function will retrieve the details/metadata of the current active study
as configured in the internal state object using `set_study()` function.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# select a specific environment/location dataset
set_study("2018 PVT Environment Number 1")

# retrieve the general information of the selected environment/location
info <- get_study_info()
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}, \code{\link{set_study}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
