% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETF.R
\name{LogLikGTEF}
\alias{LogLikGTEF}
\title{Log-likelihood function for the generalized tick-exponential family (GTEF) of distributions.}
\usage{
LogLikGTEF(y, eta, phi, alpha, p, g)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{eta}{This is the location parameter \eqn{\eta}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{p}{This is the shape parameter, which must be positive.}

\item{g}{This is the "link" function. The function \eqn{g} is to be differentiated. Therefore, \eqn{g} must be written as a function. For example, {g<-function(y)\{log(y)\}} for log link function.}
}
\value{
\code{\link{LogLikGAD}} provides the realized value of the Log-likelihood function of the generalized quantile-based asymmetric family of distributions.
}
\description{
Log-Likelihood function \eqn{\ell_n(\eta,\phi,\alpha,p)=\ln[L_n(\eta,\phi,\alpha,p)]}
in the generalized tick-exponential family of densities discussed in Gijbels et al. (2019b).
}
\examples{
# Examples
y<-rnorm(100)
g_id<-function(y){y}
g_log<-function(y){log(y)}
LogLikGTEF(y,eta=0,phi=1,alpha=0.5,p=2,g=g_id) # For identity-link
LogLikGTEF(rexp(100,0.1),eta=10,phi=1,alpha=0.5,p=2,g=g_log) # For log-link

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
