% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AEPD.R
\name{LogLikAEPD}
\alias{LogLikAEPD}
\title{Log-likelihood function for the quantile-based asymmetric exponential power distribution (AEPD) of distributions.}
\usage{
LogLikAEPD(y, mu, phi, alpha, p)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{p}{This is the shape parameter, which must be positive.}
}
\value{
\code{\link{LogLikAEPD}} provides the realized value of the Log-likelihood function of the quantile-based asymmetric exponential power distribution.
}
\description{
Log-Likelihood function \eqn{\ell_n(\mu,\phi,\alpha,p)=\ln[L_n(\mu,\phi,\alpha,p)]}
in the quantile-based asymmetric exponential power distribution (AEPD) of densities defined in Gijbels et al. (2019b).
}
\examples{
# Example
y<-rnorm(100)
LogLikAEPD(rexp(100,0.1),mu=10,phi=1,alpha=0.5,p=2)


}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.

}
}
